/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.AbstractInlinedValueProfile;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.api.profiles.Profile;

public final class InlinedIntValueProfile
extends AbstractInlinedValueProfile {
    private static final InlinedIntValueProfile DISABLED;
    private final InlineSupport.IntField cachedValue;

    private InlinedIntValueProfile() {
        this.cachedValue = null;
    }

    private InlinedIntValueProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue = target.getPrimitive(1, InlineSupport.IntField.class);
    }

    public int profile(Node node, int value) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            int v2;
            if (localState == 1 && (v2 = this.cachedValue.get(node)) == value) {
                return v2;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0) {
                this.cachedValue.set(node, value);
                this.state.set(node, 1);
            } else {
                this.state.set(node, 2);
            }
        }
        return value;
    }

    int getCachedValue(Node node) {
        if (this.state == null) {
            return 0;
        }
        return this.cachedValue.get(node);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(IntValueProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == (int)%s", this.cachedValue));
    }

    public static InlinedIntValueProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedIntValueProfile(target);
        }
        return InlinedIntValueProfile.getUncached();
    }

    public static InlinedIntValueProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedIntValueProfile profile;
        DISABLED = profile = new InlinedIntValueProfile();
    }
}

