/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

public final class ExactMath {
    private ExactMath() {
    }

    public static int multiplyHigh(int x2, int y2) {
        long r2 = (long)x2 * (long)y2;
        return (int)(r2 >> 32);
    }

    public static int multiplyHighUnsigned(int x2, int y2) {
        long xl = (long)x2 & 0xFFFFFFFFL;
        long yl = (long)y2 & 0xFFFFFFFFL;
        long r2 = xl * yl;
        return (int)(r2 >> 32);
    }

    public static long multiplyHigh(long x2, long y2) {
        long x0 = x2 & 0xFFFFFFFFL;
        long x1 = x2 >> 32;
        long y0 = y2 & 0xFFFFFFFFL;
        long y1 = y2 >> 32;
        long z0 = x0 * y0;
        long t2 = x1 * y0 + (z0 >>> 32);
        long z1 = t2 & 0xFFFFFFFFL;
        long z2 = t2 >> 32;
        return x1 * y1 + z2 + ((z1 += x0 * y1) >> 32);
    }

    public static long multiplyHighUnsigned(long x2, long y2) {
        long x0 = x2 & 0xFFFFFFFFL;
        long x1 = x2 >>> 32;
        long y0 = y2 & 0xFFFFFFFFL;
        long y1 = y2 >>> 32;
        long z0 = x0 * y0;
        long t2 = x1 * y0 + (z0 >>> 32);
        long z1 = t2 & 0xFFFFFFFFL;
        long z2 = t2 >>> 32;
        return x1 * y1 + z2 + ((z1 += x0 * y1) >>> 32);
    }

    public static float truncate(float x2) {
        return (float)ExactMath.truncate((double)x2);
    }

    public static double truncate(double x2) {
        return x2 < 0.0 ? Math.ceil(x2) : Math.floor(x2);
    }
}

