/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.mixin;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.common.block.tile.RelaySplitterTile;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RelaySplitterTile.class}, remap=false)
public abstract class RelaySplitterTileMixin
extends AbstractSourceMachine {
    @Shadow
    ArrayList<BlockPos> toList;
    @Shadow
    ArrayList<BlockPos> fromList;

    public RelaySplitterTileMixin(BlockEntityType<?> manaTile, BlockPos pos, BlockState state) {
        super(manaTile, pos, state);
    }

    @Shadow
    public abstract void createParticles(BlockPos var1, BlockPos var2);

    @Inject(method={"processFromList"}, at={@At(value="HEAD")}, cancellable=true)
    void addCapToProcessFrom(CallbackInfo ci) {
        ci.cancel();
        this.arseng$processStaleBlockPositions(this.fromList, false);
    }

    @Inject(method={"processToList"}, at={@At(value="HEAD")}, cancellable=true)
    void addCapToProcessTo(CallbackInfo ci) {
        ci.cancel();
        this.arseng$processStaleBlockPositions(this.toList, true);
    }

    @Unique
    private void arseng$processStaleBlockPositions(ArrayList<BlockPos> posList, boolean sendSource) {
        if (posList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        for (BlockPos pos : posList) {
            if (!Objects.requireNonNull(this.f_58857_).m_46749_(pos)) continue;
            BlockEntity be = this.f_58857_.m_7702_(pos);
            if (be == null) {
                stale.add(pos);
                continue;
            }
            LazyOptional cap = be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(this.m_58899_(), pos));
            cap.ifPresent(sourceTile -> {
                Object toTile;
                Object fromTile = sendSource ? this : sourceTile;
                Object object = toTile = sendSource ? sourceTile : this;
                if (this.transferSource((ISourceTile)fromTile, (ISourceTile)toTile, this.getTransferRate() / posList.size()) > 0) {
                    BlockPos fromPos = sendSource ? this.f_58858_ : pos;
                    BlockPos toPos = sendSource ? pos : this.f_58858_;
                    this.createParticles(fromPos, toPos);
                }
            });
            cap.addListener(sourceTile -> stale.add(pos));
        }
        for (BlockPos pos : stale) {
            posList.remove(pos);
            this.updateBlock();
        }
    }
}

