/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.recipe.RecipeUtils;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;

public class DyeCauldronBlock
extends ModCauldronBlock {
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61418_;

    public DyeCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEVEL});
    }

    public boolean m_142596_(BlockState state) {
        return (Integer)state.m_61143_((Property)LEVEL) == 3;
    }

    protected boolean m_142087_(Fluid fluid) {
        return false;
    }

    protected double m_142446_(BlockState state) {
        return (6.0 + (double)((Integer)state.m_61143_((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    protected void m_142310_(BlockState state, Level level, BlockPos pos, Fluid fluid) {
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            if (te.handleInteraction(player, hand)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!CommonConfigs.CAULDRON_CRAFTING.get().booleanValue()) {
                return InteractionResult.PASS;
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            SoftFluidStack fluid = tank.getFluid();
            if (fluid.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                ItemStack stack = player.m_21120_(hand);
                Item item = stack.m_41720_();
                if (item instanceof DyeItem) {
                    DyeItem di = (DyeItem)item;
                    return DyeCauldronBlock.addDye(level, te, stack, player, di);
                }
                Pair<ItemStack, Float> crafted = RecipeUtils.craftWithFluidAndDye(level, tank.getFluid(), stack);
                if (crafted != null && this.doCraftItem(level, pos, player, hand, fluid, stack, (ItemStack)crafted.getFirst(), ((Float)crafted.getSecond()).floatValue(), CommonConfigs.DYE_RECIPES_PER_LAYER.get())) {
                    te.m_6596_();
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void handleEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Sheep) {
            LiquidCauldronBlockTile te;
            SoftFluidStack fluid;
            Sheep sheep = (Sheep)entity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof LiquidCauldronBlockTile && (fluid = (te = (LiquidCauldronBlockTile)blockEntity).getSoftFluidTank().getFluid()).is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                DyeColor dye = DyeBottleItem.getClosestDye(fluid);
                if (sheep.m_29874_() != dye) {
                    sheep.m_29855_(dye);
                    te.consumeOneLayer();
                    level.m_142346_(entity, GameEvent.f_157792_, pos);
                }
            }
        }
    }

    @Override
    public BlockState updateStateOnFluidChange(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        int height = fluid.getCount();
        state = fluid.isEmpty() ? Blocks.f_50256_.m_49966_() : (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(height));
        return state;
    }

    public static void playDyeSoundAndConsume(BlockState state, BlockPos pos, Level level, Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
        }
        level.m_5594_(player, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.3f);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public static InteractionResult addDye(Level level, LiquidCauldronBlockTile tile, ItemStack stack, Player player, DyeItem dyeItem) {
        SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
        if (!level.m_5776_()) {
            int count = fluid.getCount();
            if (count == 3) {
                fluid.setCount(2);
            }
            SoftFluidStack dummyStack = DyeBottleItem.toFluidStack(dyeItem.m_41089_(), 1);
            LiquidMixer.mixDye(fluid, dummyStack);
            fluid.setCount(count);
            tile.m_6596_();
        }
        DyeCauldronBlock.playDyeSoundAndConsume(tile.m_58900_(), tile.m_58899_(), level, player, stack);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

