/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.jei;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.jei.TickingDataModelWrapper;
import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SimChamberCategory
implements IRecipeCategory<TickingDataModelWrapper> {
    public static final RecipeType<TickingDataModelWrapper> TYPE = RecipeType.create((String)"hostilenetworks", (String)"sim_chamber", TickingDataModelWrapper.class);
    public static final ResourceLocation TEXTURES = new ResourceLocation("hostilenetworks", "textures/jei/sim_chamber.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component name;
    private int ticks = 0;
    private long lastTickTime = 0L;
    static List<TickingDataModelWrapper> recipes;
    private ModelTier currentTier = ModelTier.BASIC;

    public SimChamberCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, 0, 116, 43);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Hostile.Blocks.SIM_CHAMBER.get()));
        this.name = Component.m_237115_((String)((Block)Hostile.Blocks.SIM_CHAMBER.get()).m_7705_());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.name;
    }

    public RecipeType<TickingDataModelWrapper> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TickingDataModelWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 4).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.model);
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 4).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 4).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.baseDrop);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 26).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.prediction);
    }

    public void draw(TickingDataModelWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gfx, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        long time = mc.f_91073_.m_46467_();
        int width = Mth.m_14167_((float)(35.0f * ((float)(this.ticks % 40) + mc.m_91297_()) / 40.0f));
        gfx.m_280163_(TEXTURES, 52, 9, 0.0f, 43.0f, width, 6, 256, 256);
        if (time != this.lastTickTime) {
            if (++this.ticks % 30 == 0) {
                ModelTier next = this.currentTier.next();
                if (next == this.currentTier) {
                    next = ModelTier.BASIC;
                }
                for (TickingDataModelWrapper t : recipes) {
                    t.setTier(next);
                }
                this.currentTier = next;
            }
            this.lastTickTime = time;
        }
        Component comp = recipe.currentTier.getComponent();
        width = font.m_92852_((FormattedText)comp);
        gfx.m_280430_(font, recipe.currentTier.getComponent(), 33 - width / 2, 30, recipe.currentTier.color());
        DecimalFormat fmt = new DecimalFormat("##.##%");
        String msg = fmt.format(recipe.currentTier.accuracy());
        width = font.m_92895_(msg);
        gfx.m_280056_(font, msg, 114 - width, 30, 0xFFFFFF, true);
    }
}

