/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.other;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import com.teamabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.teamabnormals.upgrade_aquatic.common.block.BedrollBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Lionfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.other.UACriteriaTriggers;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class UAEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Drowned) {
            Drowned drowned = (Drowned)entity;
            drowned.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)drowned, Turtle.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof AbstractFish) {
            AbstractFish fish = (AbstractFish)entity;
            fish.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)fish, Pike.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_HIDING_IN_PICKERELWEED::test));
            if (entity instanceof TropicalFish) {
                fish.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)fish, Lionfish.class, 8.0f, 1.6, 1.4, EntitySelector.f_20402_::test));
            }
        }
        if (entity instanceof WaterAnimal) {
            WaterAnimal waterAnimal = (WaterAnimal)entity;
            if (!(entity instanceof Enemy)) {
                if (entity instanceof Dolphin) {
                    Dolphin dolphin = (Dolphin)entity;
                    dolphin.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)dolphin, new Class[]{Thrasher.class}).m_26044_(new Class[0]));
                    dolphin.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)dolphin, 1.2, true));
                } else {
                    waterAnimal.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)waterAnimal, Thrasher.class, 20.0f, 1.4, 1.6, EntitySelector.f_20402_::test));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        ServerPlayer serverPlayer;
        ServerStatsCounter statisticsManager;
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Phantom && (livingEntity = ((Phantom)entity).m_5448_()) instanceof ServerPlayer && (statisticsManager = (serverPlayer = (ServerPlayer)livingEntity).m_8951_()).m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)) < 72000) {
            ((Phantom)entity).m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        if (event.getPos() != null) {
            BlockState state = player.m_20193_().m_8055_(event.getPos());
            if (event.getResultStatus() == null && state.m_60819_().m_76186_() == 8 && state.m_60734_() instanceof BedrollBlock && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.m_6084_() && !player.m_9236_().m_5776_()) {
                    UACriteriaTriggers.SLEEP_UNDERWATER.trigger(serverPlayer);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        Player entity = event.getEntity();
        BlockPos spawn = event.getNewSpawn();
        if (spawn != null && entity.m_20193_().m_8055_(spawn).m_60734_() instanceof BedrollBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Items.f_42447_ && entity.m_6084_() && entity instanceof Squid) {
            ItemStack bucket;
            Squid squid = (Squid)entity;
            squid.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            if (squid.m_6095_() == EntityType.f_20480_) {
                bucket = new ItemStack((ItemLike)UAItems.SQUID_BUCKET.get());
            } else if (squid.m_6095_() == EntityType.f_147034_) {
                bucket = new ItemStack((ItemLike)UAItems.GLOW_SQUID_BUCKET.get());
            } else {
                return;
            }
            Bucketable.m_148822_((Mob)squid, (ItemStack)bucket);
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)stack, (Player)player, (ItemStack)bucket, (boolean)false);
            player.m_21008_(event.getHand(), itemstack2);
            if (!event.getLevel().m_5776_()) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucket);
            }
            entity.m_146870_();
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().m_5776_()));
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof Pike && event.getEntity().m_6060_()) {
            Level level = event.getEntity().m_9236_();
            for (ItemEntity itemEntity : event.getDrops()) {
                ItemStack itemstack;
                ItemStack stack = itemEntity.m_32055_();
                Optional optional = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), level);
                if (!optional.isPresent() || (itemstack = ((SmeltingRecipe)optional.get()).m_8043_(level.m_9598_())).m_41619_()) continue;
                ItemStack itemstack1 = itemstack.m_41777_();
                itemstack1.m_41764_(stack.m_41613_() * itemstack.m_41613_());
                itemEntity.m_32045_(itemstack1);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        Player player2 = event.player;
        if (!event.player.m_9236_().f_46443_ && event.player.m_9236_().m_46467_() % 5L == 0L && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerStatsCounter statisticsManager = serverPlayer.m_8951_();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            object2intmap.put((Object)Stats.f_12988_.m_12902_((Object)Stats.f_12992_), statisticsManager.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundAwardStatsPacket((Object2IntMap)object2intmap));
        }
        ItemStack headSlotStack = player2.m_6844_(EquipmentSlot.HEAD);
        if (event.phase == TickEvent.Phase.END && player2.m_21515_() && !headSlotStack.m_41619_() && headSlotStack.m_150930_(Items.f_42354_) && ((Boolean)UAConfig.COMMON.turtleShellRework.get()).booleanValue()) {
            int timeTillDamage;
            int n = timeTillDamage = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)headSlotStack) > 0 ? 40 * (1 + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)headSlotStack) / 2) : 40;
            if (player2.m_204029_(FluidTags.f_13131_)) {
                player2.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 100));
                if (player2.m_9236_().m_46467_() % (long)timeTillDamage == 0L) {
                    headSlotStack.m_41622_(1, (LivingEntity)player2, p_213341_0_ -> p_213341_0_.m_21166_(EquipmentSlot.HEAD));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof Player) {
            Player player = (Player)mountingEntity;
            if (entityBeingMounted instanceof Thrasher) {
                Thrasher thrasher = (Thrasher)entityBeingMounted;
                if (event.isDismounting() && player.m_6084_() && !player.m_7500_() && !player.m_5833_() && thrasher.m_6084_() && !thrasher.isStunned()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block livingCoral;
        ResourceLocation name;
        String path;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        RandomSource random = player.m_217043_();
        if (stack.m_150930_(Items.f_151056_) && ((path = (name = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())).m_135815_()).contains("dead") || path.contains("elder")) && path.contains("coral") && !path.contains("coralstone") && (livingCoral = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name.m_135827_(), path.replace("dead_", "").replace("elder_", "")))) != null) {
            level.m_46597_(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)livingCoral.m_49966_()));
            level.m_186460_(pos, livingCoral, 60 + level.m_213780_().m_188503_(40));
            level.m_5594_(player, pos, SoundEvents.f_12441_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 5; ++i) {
                double d1 = random.m_188583_() * 0.02;
                double d6 = (double)pos.m_123341_() + random.m_188500_();
                double d7 = (double)pos.m_123342_() + random.m_188500_() * state.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
                double d8 = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_175826_, d6, d7, d8, d1, d1, d1);
            }
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(event.getHand()).m_41774_(1);
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BEACHGRASS.get()).m_5456_(), 1, 12, 1), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.WHITE_SEAROCKET.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.PINK_SEAROCKET.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.PICKERELWEED.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.FINGER_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.ACAN_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.BRANCH_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.PILLOW_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.SILK_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.PETAL_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.MOSS_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.ROCK_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.STAR_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.CHROME_CORAL_BLOCK.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)UABlocks.EMBEDDED_AMMONITE.get()).m_5456_(), 1, 5, 1)});
        TradeUtil.addRareWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, ((Block)UABlocks.DRIFTWOOD_LOG.get()).m_5456_(), 1, 16, 1), new TradeUtil.BlueprintTrade(5, (Item)UAItems.PIKE_BUCKET.get(), 1, 4, 1), new TradeUtil.BlueprintTrade(5, (Item)UAItems.LIONFISH_BUCKET.get(), 1, 4, 1), new TradeUtil.BlueprintTrade(5, (Item)UAItems.NAUTILUS_BUCKET.get(), 1, 4, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35590_, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)UAItems.MULBERRY.get(), 5, 16, 5)});
        if (event.getType().equals((Object)VillagerProfession.f_35591_)) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)UAItems.PERCH.get(), 6), new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)UAItems.COOKED_PERCH.get(), 6), 16, 5, 0.05f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)3, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.PERCH.get(), 14, 1, 16, 20), new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)UAItems.PIKE.get(), 6), new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)UAItems.COOKED_PIKE.get(), 6), 16, 10, 0.05f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.PIKE.get(), 5, 1, 16, 25), new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)UAItems.LIONFISH.get(), 6), new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)UAItems.COOKED_LIONFISH.get(), 6), 16, 15, 0.05f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)5, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.LIONFISH.get(), 3, 1, 16, 30)});
        }
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35595_, (int)5, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(5, ((Block)UABlocks.TOOTH_TILES.get()).m_5456_(), 1, 12, 30), new TradeUtil.BlueprintTrade(5, ((Block)UABlocks.TOOTH_BRICKS.get()).m_5456_(), 1, 12, 30)});
        if (((Boolean)UAConfig.COMMON.clericsBuyThrasherTeeth.get()).booleanValue()) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35589_, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.THRASHER_TOOTH.get(), 1, 1, 12, 15)});
        }
        if (((Boolean)UAConfig.COMMON.leatherworkersSellBedrolls.get()).booleanValue()) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35593_, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.WHITE_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.ORANGE_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.MAGENTA_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.LIGHT_BLUE_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.YELLOW_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.LIME_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.PINK_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.GRAY_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.LIGHT_GRAY_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.CYAN_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.PURPLE_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BLUE_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BROWN_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.GREEN_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.RED_BEDROLL.get()).m_5456_(), 1, 8, 10), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BLACK_BEDROLL.get()).m_5456_(), 1, 8, 10)});
        }
    }
}

