/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.blockswap.swapper.Swapper;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class CodecUtil {
    public static Codec<Block> BLOCK_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(BuiltInRegistries.f_256975_);
    public static Codec<Fluid> FLUID_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(BuiltInRegistries.f_257020_);
    public static Codec<Pair<BlockState, BlockState>> PAIR_STATE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Swapper.COMMENTED_STATE_CODEC.fieldOf("old").forGetter(Pair::getFirst), (App)Swapper.COMMENTED_STATE_CODEC.fieldOf("new").forGetter(Pair::getSecond)).apply((Applicative)builder, Pair::new));
    public static Codec<Map<BlockState, BlockState>> KEYABLE_BLOCKSTATE_CODEC = PAIR_STATE_CODEC.listOf().xmap(s -> {
        IdentityHashMap<BlockState, BlockState> map = new IdentityHashMap<BlockState, BlockState>();
        for (Pair blockStateBlockStatePair : s) {
            map.put((BlockState)blockStateBlockStatePair.getFirst(), (BlockState)blockStateBlockStatePair.getSecond());
        }
        return map;
    }, map -> {
        ArrayList pairs = new ArrayList();
        map.forEach((state, state2) -> pairs.add(new Pair(state, state2)));
        return pairs;
    });

    public static <T> Codec<T> createLoggedExceptionRegistryCodec(Registry<T> registry) {
        return ResourceLocation.f_135803_.comapFlatMap(location -> {
            Optional result = registry.m_6612_(location);
            if (result.isEmpty()) {
                StringBuilder registryElements = new StringBuilder();
                for (int i = 0; i < registry.m_6579_().size(); ++i) {
                    Object object = registry.m_7942_(i);
                    registryElements.append(i).append(". \"").append(registry.m_7981_(object).toString()).append("\"\n");
                }
                return DataResult.error(() -> String.format("\"%s\" is not a valid id in registry: %s.\nCurrent Registry Values:\n\n%s\n", location.toString(), registry, registryElements));
            }
            return DataResult.success(result.get());
        }, arg_0 -> registry.m_7981_(arg_0));
    }
}

