/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.connection;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BezierConnection
implements IConnection {
    public static final Codec<BezierConnection> CODEC = RecordCodecBuilder.create(i -> i.group((App)SimpleConnection.CODEC.fieldOf("fromPos").forGetter(BezierConnection::getFromPos), (App)SimpleConnection.CODEC.fieldOf("toPos").forGetter(BezierConnection::getToPos), (App)Codec.INT.fieldOf("tubeSegments").forGetter(BezierConnection::getTubeSegments), (App)Vec3.f_231074_.listOf().fieldOf("curvePoints").forGetter(BezierConnection::getBezierPoints)).apply((Applicative)i, BezierConnection::new));
    public static final float MAX_DISTANCE = 40.0f;
    public static final float MAX_ANGLE = 0.6f;
    private final UUID uuid = UUID.randomUUID();
    private final SimpleConnection fromPos;
    @Nullable
    private SimpleConnection toPos;
    private int tubeSegments;
    private List<Vec3> bezierPoints;
    private ResponseDTO valid;
    private final int detailLevel;

    private BezierConnection(SimpleConnection fromPos, SimpleConnection toPos, int tubeSegments, List<Vec3> bezierPoints) {
        this(fromPos, toPos, tubeSegments, (int)Math.max(3.0, fromPos.pos().m_252807_().m_82554_(toPos.pos().m_252807_())));
        this.bezierPoints = bezierPoints;
    }

    public BezierConnection(SimpleConnection fromPos, @Nullable SimpleConnection toPos) {
        this(fromPos, toPos, 1, toPos != null ? (int)Math.max(3.0, fromPos.pos().m_252807_().m_82554_(toPos.pos().m_252807_())) : 0);
    }

    public BezierConnection(SimpleConnection fromPos, SimpleConnection toPos, int tubeSegments, int detailLevel) {
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.detailLevel = detailLevel;
        this.tubeSegments = tubeSegments;
    }

    public List<Vec3> getBezierPoints() {
        if (this.bezierPoints != null) {
            return this.bezierPoints;
        }
        if (this.toPos == null) {
            return List.of();
        }
        Vec3 fromPos = this.fromPos.pos().m_252807_();
        Vec3 toPos = new Vec3((double)this.toPos.pos().m_123341_() + 0.5, (double)this.toPos.pos().m_123342_() + 0.5, (double)this.toPos.pos().m_123343_() + 0.5);
        this.bezierPoints = this.calculateBezierCurve(fromPos, this.fromPos.direction(), toPos, this.detailLevel, this.getToPos().direction());
        return this.bezierPoints;
    }

    private List<Vec3> calculateBezierCurve(Vec3 from, Direction direction, Vec3 toVec, int detailLevel, @Nullable Direction finalDirection) {
        this.valid = null;
        double distance = from.m_82554_(toVec);
        Vec3 controlPoint1 = this.createFirstControlPoint(from, direction, distance);
        Vec3 controlPoint2 = this.createSecondControlPoint(toVec, direction, distance, Vec3.m_82528_((Vec3i)finalDirection.m_122436_()));
        ArrayList<Vec3> curvePoints = new ArrayList<Vec3>();
        for (int i = 0; i <= detailLevel; ++i) {
            double t = (double)i / (double)detailLevel;
            Vec3 point = this.cubicBezier(from, controlPoint1, controlPoint2, toVec, t);
            curvePoints.add(point);
        }
        return curvePoints;
    }

    private Vec3 createFirstControlPoint(Vec3 from, Direction direction, double distance) {
        double controlDistance = distance * 0.4;
        return from.m_82520_((double)direction.m_122429_() * controlDistance, (double)direction.m_122430_() * controlDistance, (double)direction.m_122431_() * controlDistance);
    }

    private Vec3 createSecondControlPoint(Vec3 to, Direction fromDirection, double distance, @Nullable Vec3 finalDirection) {
        if (finalDirection != null) {
            double controlDistance = distance * 0.4;
            return to.m_82492_(finalDirection.f_82479_ * controlDistance, finalDirection.f_82480_ * controlDistance, finalDirection.f_82481_ * controlDistance);
        }
        Direction oppositeDirection = fromDirection.m_122424_();
        double controlDistance = distance * 0.4;
        return to.m_82520_((double)oppositeDirection.m_122429_() * controlDistance, (double)oppositeDirection.m_122430_() * controlDistance, (double)oppositeDirection.m_122431_() * controlDistance);
    }

    private Vec3 cubicBezier(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, double t) {
        double oneMinusT = 1.0 - t;
        double oneMinusTCubed = oneMinusT * oneMinusT * oneMinusT;
        double oneMinusTSquared = oneMinusT * oneMinusT;
        double tSquared = t * t;
        double tCubed = tSquared * t;
        double x = oneMinusTCubed * p0.f_82479_ + 3.0 * oneMinusTSquared * t * p1.f_82479_ + 3.0 * oneMinusT * tSquared * p2.f_82479_ + tCubed * p3.f_82479_;
        double y = oneMinusTCubed * p0.f_82480_ + 3.0 * oneMinusTSquared * t * p1.f_82480_ + 3.0 * oneMinusT * tSquared * p2.f_82480_ + tCubed * p3.f_82480_;
        double z = oneMinusTCubed * p0.f_82481_ + 3.0 * oneMinusTSquared * t * p1.f_82481_ + 3.0 * oneMinusT * tSquared * p2.f_82481_ + tCubed * p3.f_82481_;
        return new Vec3(x, y, z);
    }

    public float getMaxAngleBezierAngle() {
        Vec3 secondDirection;
        if (this.bezierPoints == null) {
            this.bezierPoints = this.getBezierPoints();
        }
        Vec3 first = this.getBezierPoints().get(0);
        Vec3 second = this.getBezierPoints().get(1);
        Direction direction = this.fromPos.direction();
        Vec3 firstDirection = new Vec3((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
        float initialAngle = (float)Math.acos(firstDirection.m_82526_(secondDirection = second.m_82546_(first).m_82541_()) / (firstDirection.m_82553_() * secondDirection.m_82553_()));
        if ((double)initialAngle >= 2.0) {
            return initialAngle;
        }
        return this.getMaxAngle();
    }

    private float getMaxAngle() {
        float maxAngle = 0.0f;
        Vec3 lastPoint = this.bezierPoints.get(0);
        for (int i = 1; i < this.bezierPoints.size() - 1; ++i) {
            Vec3 currentPoint = this.bezierPoints.get(i);
            Vec3 nextPoint = this.bezierPoints.get(i + 1);
            Vec3 vector1 = currentPoint.m_82546_(lastPoint);
            Vec3 vector2 = nextPoint.m_82546_(currentPoint);
            float angle = (float)Math.acos(vector1.m_82526_(vector2) / (vector1.m_82553_() * vector2.m_82553_()));
            maxAngle = Math.max(maxAngle, angle);
            lastPoint = currentPoint;
        }
        return maxAngle;
    }

    public float distance() {
        if (this.toPos == null) {
            return 0.0f;
        }
        return (float)this.fromPos.pos().m_252807_().m_82554_(this.toPos.pos().m_252807_());
    }

    public ResponseDTO getValidation() {
        if (this.valid != null) {
            return this.valid;
        }
        if (this.fromPos == null || this.toPos == null) {
            this.valid = ResponseDTO.invalid("placement.create_hypertube.no_valid_points");
            return this.valid;
        }
        if (this.getMaxAngleBezierAngle() >= 0.6f) {
            this.valid = ResponseDTO.invalid("placement.create_hypertube.angle_too_high");
            return this.valid;
        }
        if (this.distance() >= 40.0f) {
            this.valid = ResponseDTO.invalid("placement.create_hypertube.distance_too_high");
            return this.valid;
        }
        if (this.distance() <= 1.0f) {
            this.valid = ResponseDTO.invalid();
            return this.valid;
        }
        return ResponseDTO.get(true);
    }

    public static BezierConnection of(SimpleConnection from, @Nullable SimpleConnection toPos) {
        return new BezierConnection(from, toPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPath(LerpedFloat animation, boolean isValid) {
        Vec3 pos1 = this.fromPos.pos().m_252807_();
        int id = 0;
        for (Vec3 bezierPoint : this.getBezierPoints()) {
            BezierConnection.line(this.uuid, id, pos1, bezierPoint, animation, !isValid);
            pos1 = bezierPoint;
            ++id;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void line(UUID uuid, int id, Vec3 start, Vec3 end, LerpedFloat animation, boolean hasException) {
        int color = Color.mixColors((int)15359019, (int)9817409, (float)animation.getValue());
        if (hasException) {
            Vec3 diff = end.m_82546_(start);
            start = start.m_82549_(diff.m_82490_(0.2));
            end = start.m_82549_(diff.m_82490_(-0.2));
        }
        Outliner.getInstance().showLine((Object)Pair.of((Object)uuid, (Object)id), start, end).lineWidth(0.125f).disableLineNormals().colored(color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void outlineBlocks(BlockPos pos) {
        Outliner.getInstance().showAABB((Object)pos.m_121878_(), new AABB((double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).colored(15359019).lineWidth(0.125f).disableLineNormals();
    }

    public BezierConnection invert() {
        ArrayList<Vec3> newBezier = new ArrayList<Vec3>(this.bezierPoints);
        Collections.reverse(newBezier);
        return new BezierConnection(new SimpleConnection(this.toPos.pos(), this.toPos.direction().m_122424_()), this.fromPos, this.tubeSegments, newBezier);
    }

    @Override
    public BezierConnection getThisEntranceConnection(Level level) {
        return this;
    }

    @Override
    public Direction getThisEntranceDirection(Level level) {
        return this.fromPos.direction();
    }

    @Override
    public boolean isSameConnection(IConnection connection) {
        return this.fromPos.isSameConnection(connection) || connection.equals(this);
    }

    @Override
    public SimpleConnection getThisConnection() {
        return this.getFromPos();
    }

    @Override
    public void updateTubeSegments(Level level) {
        this.tubeSegments = this.tubeSegments == 1 ? 2 : 1;
    }

    public String toString() {
        return "BezierConnection{fromPos=" + this.fromPos + ", toPos=" + this.toPos + ", isValid=" + this.valid + "}";
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SimpleConnection getFromPos() {
        return this.fromPos;
    }

    @Nullable
    public SimpleConnection getToPos() {
        return this.toPos;
    }

    public int getTubeSegments() {
        return this.tubeSegments;
    }
}

