/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PacketDecoder.class})
public class PacketDecoderMixin<T extends PacketListener> {
    @Inject(method={"decode"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/jfr/JvmProfiler;onPacketReceived(IILjava/net/SocketAddress;I)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void checkSize(ChannelHandlerContext p_130535_, ByteBuf p_130536_, List<Object> p_130537_, CallbackInfo ci, int size, FriendlyByteBuf friendlybytebuf, int packetID, Packet packet) {
        if (size > 0x800000 && (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages || !((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits)) {
            PacketLogging.logPacket(packet, " with packetid:" + packetID + " received has too large size:" + size + " bytes");
        }
    }

    @Inject(method={"decode"}, at={@At(value="INVOKE", target="Ljava/io/IOException;<init>(Ljava/lang/String;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onDecode(ChannelHandlerContext p_130535_, ByteBuf buffer, List<Object> p_130537_, CallbackInfo ci, int size, FriendlyByteBuf friendlybytebuf, int packetID, Packet packet) throws IOException {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            PacketLogging.logPacket(packet, " id " + packetID + " larger than expected error detected, printing packet and buffer. Stacktrace gets logged after this");
            boolean prev = ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages;
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = true;
            PacketLogging.logPacket(buffer.copy(buffer.readerIndex(), buffer.readableBytes()), " id " + packetID + " data of " + buffer.readableBytes() + " extra bytes: ");
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = prev;
        }
        throw new IOException("Packet " + ((ConnectionProtocol)p_130535_.channel().attr(Connection.f_129461_).get()).m_129582_() + "/" + packetID + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + friendlybytebuf.readableBytes() + " bytes extra whilst reading packet " + packetID);
    }

    @Redirect(method={"decode"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/ConnectionProtocol;createPacket(Lnet/minecraft/network/protocol/PacketFlow;ILnet/minecraft/network/FriendlyByteBuf;)Lnet/minecraft/network/protocol/Packet;"))
    private Packet<?> checkDecodingError(ConnectionProtocol instance, PacketFlow packetFlow, int packetID, FriendlyByteBuf buf) {
        try {
            return instance.m_178321_(packetFlow, packetID, buf);
        }
        catch (Throwable t) {
            if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                int prevIndex = buf.readerIndex();
                buf.resetReaderIndex();
                String name = "unknown";
                for (Object2IntMap.Entry entry : ((ConnectionProtocol.PacketSet)instance.f_129574_.get((Object)packetFlow)).f_129604_.object2IntEntrySet()) {
                    if (entry.getIntValue() != packetID) continue;
                    name = ((Class)entry.getKey()).toString();
                }
                Connectivity.LOGGER.warn("Decoding error for packet:" + name, t);
                Connectivity.LOGGER.warn("<------ Packet Data Export: ------>");
                boolean prev = ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages;
                ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = true;
                PacketLogging.logPacket(buf);
                ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = prev;
                Connectivity.LOGGER.warn("<------ Packet Data Export End: ------>");
                buf.readerIndex(prevIndex);
            }
            throw t;
        }
    }
}

