/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.entity;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.AbstractWhirlwind;
import com.aetherteam.aether.entity.monster.PassiveWhirlwind;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.PacketRelay;
import com.google.common.collect.Lists;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.capability.player.LCPlayer;
import com.legacy.lost_aether.entity.CloudShotEntity;
import com.legacy.lost_aether.entity.FallingRockEntity;
import com.legacy.lost_aether.entity.util.AerwhaleKingPart;
import com.legacy.lost_aether.entity.util.LostNameGen;
import com.legacy.lost_aether.mixin.AbstractWhirlwindAccessor;
import com.legacy.lost_aether.registry.LCBlocks;
import com.legacy.lost_aether.registry.LCSounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.simple.SimpleChannel;

public class AerwhaleKingEntity
extends FlyingMob
implements AetherBossMob<AerwhaleKingEntity>,
Enemy {
    public static final EntityDataAccessor<Component> BOSS_NAME = SynchedEntityData.m_135353_(AerwhaleKingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    public static final EntityDataAccessor<Boolean> HAS_TARGET_POS = SynchedEntityData.m_135353_(AerwhaleKingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> STUN_TIME = SynchedEntityData.m_135353_(AerwhaleKingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FOG_TIME = SynchedEntityData.m_135353_(AerwhaleKingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(AerwhaleKingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<BlockPos> CRASH_POS = SynchedEntityData.m_135353_(AerwhaleKingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private BossRoomTracker<AerwhaleKingEntity> platinumDungeon;
    private final ServerBossEvent bossFight;
    public int courseIndex;
    public int shootCooldown = 100;
    public int fogCooldown = 400;
    public boolean courseFlipped;
    private int shootTime;
    private float shootAnim;
    private float shootAnimO;
    private float invisAnim = 1.0f;
    private float invisAnimO = 1.0f;
    private final AerwhaleKingPart[] subEntities;
    public final AerwhaleKingPart midBody;
    public final AerwhaleKingPart backBody;
    public final AerwhaleKingPart tail;

    public AerwhaleKingEntity(EntityType<? extends AerwhaleKingEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new WhaleMovementController(this);
        this.bossFight = new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
        this.bossFight.m_8321_(false);
        this.f_21364_ = 50;
        this.f_19811_ = true;
        this.midBody = new AerwhaleKingPart(this, "mid_body", 3.0f, 3.0f);
        this.backBody = new AerwhaleKingPart(this, "back_body", 2.8f, 3.0f);
        this.tail = new AerwhaleKingPart(this, "tail", 2.5f, 2.5f);
        this.subEntities = new AerwhaleKingPart[]{this.midBody, this.backBody, this.tail};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    public ResourceLocation getBossBarTexture() {
        return LostContentMod.locate("textures/gui/boss_bar_aerwhale_king.png");
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 30.0);
    }

    public static boolean spawnRules(EntityType<? extends AerwhaleKingEntity> entity, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, SpawnGroupData pSpawnData, CompoundTag pDataTag) {
        this.setBossName((Component)LostNameGen.generateAerwhaleKingName());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal());
        this.f_21345_.m_25352_(1, (Goal)new SpreadFogGoal());
        this.f_21345_.m_25352_(2, (Goal)new ShootTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new ChargeTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new RunIdleCourseGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_TARGET_POS, (Object)false);
        this.f_19804_.m_135372_(BOSS_NAME, (Object)Component.m_237113_((String)"Aerwhale King"));
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
        this.f_19804_.m_135372_(STUN_TIME, (Object)0);
        this.f_19804_.m_135372_(FOG_TIME, (Object)0);
        this.f_19804_.m_135372_(CRASH_POS, (Object)BlockPos.f_121853_);
    }

    public void m_6478_(MoverType type, Vec3 vec) {
        super.m_6478_(type, this.isStunned() ? Vec3.f_82478_ : vec);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.addBossSaveData(nbt);
        nbt.m_128405_("StunTime", this.getStunTime());
        nbt.m_128379_("IsShooting", this.isShooting());
        nbt.m_128405_("ShootCooldown", this.shootCooldown);
        nbt.m_128405_("FogCooldown", this.fogCooldown);
        nbt.m_128405_("CourseIndex", this.courseIndex);
        nbt.m_128379_("CourseFlipped", this.courseFlipped);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.readBossSaveData(nbt);
        this.setStunTime(nbt.m_128451_("StunTime"));
        this.setShooting(nbt.m_128471_("IsShooting"));
        this.shootCooldown = nbt.m_128451_("ShootCooldown");
        this.fogCooldown = nbt.m_128451_("FogCooldown");
        this.courseIndex = nbt.m_128451_("CourseIndex");
        this.courseFlipped = nbt.m_128471_("CourseFlipped");
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<AerwhaleKingEntity>[] getParts() {
        return this.subEntities;
    }

    public void m_8119_() {
        boolean shouldUpdatePos;
        super.m_8119_();
        if (this.hasTargetPos() || this.isShooting()) {
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
        }
        if (this.isStunned()) {
            this.m_146926_(0.0f);
        }
        boolean bl = shouldUpdatePos = (this.isStunned() || this.isShooting()) && this.m_5448_() != null;
        if (this.m_9236_().m_5776_()) {
            BlockPos pos;
            boolean foggy;
            boolean inc;
            this.shootAnimO = this.shootAnim;
            this.invisAnimO = this.invisAnim;
            boolean bl2 = inc = this.shootTime > 0;
            this.shootAnim = Mth.m_14036_((float)(this.shootAnim + (inc ? 0.5f : (this.getFogTime() >= this.getWantedFogTime() - 30 ? -0.05f : -0.3f))), (float)0.0f, (float)1.0f);
            boolean bl3 = foggy = this.getFogTime() > 20;
            if (!this.isShooting() || !foggy) {
                this.invisAnim = Mth.m_14036_((float)(this.invisAnim + (foggy && !this.isStunned() && !this.hasTargetPos() ? -0.03f : (this.isStunned() || this.hasTargetPos() ? 0.15f : 0.05f))), (float)0.0f, (float)1.0f);
            }
            if (this.shootTime > 0) {
                --this.shootTime;
            }
            if (this.isStunned()) {
                for (int i = 0; i < 2; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123806_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
                }
            } else if (this.hasTargetPos()) {
                float dist = 2.0f;
                float x = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * -dist;
                float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * dist;
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02 - (double)(x * 0.2f);
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02 - (double)(z * 0.2f);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + (double)x + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 1.0f) - (double)this.m_20205_() / 2.0, this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)z + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 1.0f) - (double)this.m_20205_() / 2.0, d0, d1, d2);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, this.m_20185_() + (double)x + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 1.0f) - (double)this.m_20205_() / 2.0, this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)z + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 1.0f) - (double)this.m_20205_() / 2.0, d0, d1, d2);
                }
            }
            if (!(pos = (BlockPos)this.f_19804_.m_135370_(CRASH_POS)).equals((Object)BlockPos.f_121853_)) {
                this.m_6034_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
            }
        } else {
            if (this.m_5448_() != null) {
                this.setBossFight(true);
            }
            this.m_21561_(this.isBossFight());
            if (!shouldUpdatePos) {
                this.f_19804_.m_135381_(CRASH_POS, (Object)BlockPos.f_121853_);
            }
            if (this.getDungeon() != null) {
                this.getDungeon().dungeonPlayers().stream().map(uuid -> this.m_9236_().m_46003_(uuid)).filter(p -> p != null && !p.m_213877_() && EntitySelector.f_20403_.test(p)).forEach(p -> LCPlayer.ifPresent(p, lcp -> {
                    boolean isFight;
                    boolean bl = isFight = this.m_6084_() && !this.m_213877_() && this.isBossFight();
                    if (lcp.inKingFight() != isFight) {
                        lcp.setKingFight(isFight);
                        if (!this.isBossFight()) {
                            lcp.setFogTime(Math.min(lcp.getFogTime(), 40));
                        }
                        lcp.syncDataToClient();
                    }
                }));
            }
        }
        float x = -Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float y = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        float midDist = -3.0f;
        float backDist = -5.7f;
        float tailDist = -8.0f;
        this.midBody.m_146867_();
        this.midBody.m_6034_(this.m_20185_() + (double)(x * midDist), this.m_20186_() + 0.5 + (double)(y * 5.0f), this.m_20189_() + (double)(z * midDist));
        this.backBody.m_146867_();
        this.backBody.m_6034_(this.m_20185_() + (double)(x * backDist), this.m_20186_() + 0.5 + (double)(y * 8.0f), this.m_20189_() + (double)(z * backDist));
        this.tail.m_146867_();
        this.tail.m_6034_(this.m_20185_() + (double)(x * tailDist), this.m_20186_() + (double)0.6f + (double)(y * 10.0f), this.m_20189_() + (double)(z * tailDist));
    }

    protected void m_8024_() {
        if (this.isStunned()) {
            this.setStunTime(this.getStunTime() - 1);
        }
        if (this.getFogTime() > 0) {
            this.setFogTime(this.getFogTime() - 1);
        }
        if (!this.isBossFight()) {
            this.setFogTime(0);
        }
        if (this.getDungeon() == null) {
            return;
        }
        if (this.isBossFight() && this.m_5448_() == null) {
            this.randomizeTarget();
        }
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
        Vec3 origin = this.getDungeon().originCoordinates();
        if (this.m_5448_() != null) {
            if (!this.isShooting()) {
                if (this.shootCooldown > 0) {
                    --this.shootCooldown;
                }
                if (this.fogCooldown > 0) {
                    --this.fogCooldown;
                }
            }
            if (!this.m_5448_().m_6084_() || this.m_5448_().m_21223_() <= 0.0f) {
                this.randomizeTarget();
            }
        }
        this.f_19794_ = this.m_20186_() > origin.f_82480_ + 2.0;
    }

    public void randomizeTarget() {
        if (this.getDungeon() == null || this.m_213877_() || !this.m_6084_()) {
            return;
        }
        List<Player> playerList = this.getDungeon().dungeonPlayers().stream().map(uuid -> this.m_9236_().m_46003_(uuid)).filter(p -> p != null && !p.m_213877_() && EntitySelector.f_20406_.and(EntitySelector.f_20403_).test((Player)p)).toList();
        Util.m_214676_(playerList, (RandomSource)this.m_217043_()).ifPresent(p -> this.m_6710_((LivingEntity)p));
    }

    public void m_6667_(@Nonnull DamageSource damageSource) {
        this.m_20256_(Vec3.f_82478_);
        if (this.m_9236_() instanceof ServerLevel) {
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.getDungeon() != null) {
                for (AreaEffectCloud cloud : this.m_9236_().m_45976_(AreaEffectCloud.class, this.getDungeon().roomBounds())) {
                    cloud.m_146870_();
                }
                for (AbstractWhirlwind whirly : this.m_9236_().m_45976_(AbstractWhirlwind.class, this.getDungeon().roomBounds())) {
                    whirly.m_146870_();
                }
                this.getDungeon().dungeonPlayers().stream().map(uuid -> this.m_9236_().m_46003_(uuid)).filter(p -> p != null && !p.m_213877_() && EntitySelector.f_20403_.test(p)).forEach(p -> LCPlayer.ifPresent(p, lcp -> {
                    lcp.setKingFight(false);
                    lcp.setFogTime(Math.min(lcp.getFogTime(), 40));
                    lcp.syncDataToClient();
                }));
                this.getDungeon().grantAdvancements(damageSource);
                this.tearDownRoom();
            }
        }
        super.m_6667_(damageSource);
    }

    public void tearDownRoom() {
        AABB box = this.getDungeon().roomBounds().m_82338_(new BlockPos(0, -20, 0)).m_82377_(0.0, 15.0, 0.0);
        for (BlockPos pos : BlockPos.m_121976_((int)((int)box.f_82288_), (int)((int)box.f_82289_), (int)((int)box.f_82290_), (int)((int)box.f_82291_), (int)((int)box.f_82292_), (int)((int)box.f_82293_))) {
            BlockState state = this.m_9236_().m_8055_(pos);
            BlockState newState = this.convertBlock(state);
            if (newState == null) continue;
            this.m_9236_().m_7731_(pos, newState, 3);
        }
    }

    public void m_7334_(Entity entity) {
        if (this.m_5448_() != null && this.hasTargetPos() && entity != this.m_5448_()) {
            this.m_7327_(entity);
        }
    }

    public boolean hurtFromPart(AerwhaleKingPart pPart, DamageSource pSource, float pDamage) {
        if (pSource.m_7639_() == this) {
            return false;
        }
        return this.m_6469_(pSource, pDamage * 0.7f);
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268549_) || source == this.m_269291_().m_269354_() || source == this.m_269291_().m_269318_() || source == this.m_269291_().m_269063_()) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity = source.m_7640_();
        if (entity instanceof Player && !(player = (Player)entity).m_21205_().m_41619_() && player.m_21205_().m_41720_() == Items.f_42751_ && player.m_7500_()) {
            this.reset();
            return false;
        }
        if (source.m_19390_() || source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (!this.isBossFight()) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_) || source.m_269533_(DamageTypeTags.f_268731_)) {
            this.m_21373_();
            return false;
        }
        if (!this.isStunned()) {
            return super.m_6469_(source, Math.max(0.0f, Math.min(amount * 0.3f, 5.0f)));
        }
        return super.m_6469_(source, Math.max(0.0f, Math.min(amount, 18.0f)));
    }

    public boolean m_7327_(Entity entityIn) {
        Player player;
        ItemStack playerItem;
        boolean flag = super.m_7327_(entityIn);
        if (entityIn instanceof Player && !(playerItem = (player = (Player)entityIn).m_21211_()).m_41619_() && playerItem.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            this.setStunned(true);
            this.m_9236_().m_7605_((Entity)player, (byte)29);
            this.m_9236_().m_7605_((Entity)player, (byte)30);
            player.m_36384_(true);
            player.m_36335_().m_41524_(playerItem.m_41720_(), 600);
            if (player.m_7655_() != null) {
                playerItem.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
            }
            this.setPosTargetted(false);
            return false;
        }
        return flag;
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty() && this.hasTargetPos()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.m_7334_(entity);
            }
        }
        super.m_6138_();
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.setBossName(name);
    }

    public boolean m_146890_() {
        return false;
    }

    public void trackDungeon() {
        if (this.getDungeon() != null) {
            this.getDungeon().trackPlayers();
            if (this.isBossFight() && this.getDungeon().dungeonPlayers().stream().filter(uuid -> EntitySelector.f_20406_.test(this.m_9236_().m_46003_(uuid))).toList().isEmpty()) {
                this.reset();
            }
        }
    }

    public void reset() {
        this.m_6710_(null);
        this.m_21153_(this.m_21233_());
        this.setPosTargetted(false);
        this.setStunned(false);
        this.setBossFight(false);
        this.setShooting(false);
        this.shootCooldown = 100;
        this.fogCooldown = 400;
        if (this.getDungeon() != null) {
            this.openRoom();
            Vec3 origin = this.getDungeon().originCoordinates();
            this.m_6021_(origin.f_82479_ - 16.0, origin.f_82480_ + 12.0, origin.f_82481_);
            this.m_9236_().m_46597_(BlockPos.m_274561_((double)origin.f_82479_, (double)origin.f_82480_, (double)(origin.f_82481_ - 8.0)), LCBlocks.songstone.m_49966_());
        }
    }

    public int getFogTime() {
        return (Integer)this.f_19804_.m_135370_(FOG_TIME);
    }

    public void setFogTime(int time) {
        this.f_19804_.m_135381_(FOG_TIME, (Object)time);
    }

    public int getStunTime() {
        return (Integer)this.f_19804_.m_135370_(STUN_TIME);
    }

    public void setStunTime(int time) {
        this.f_19804_.m_135381_(STUN_TIME, (Object)time);
    }

    public boolean hasTargetPos() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TARGET_POS);
    }

    public void setPosTargetted(boolean flag) {
        this.f_19804_.m_135381_(HAS_TARGET_POS, (Object)flag);
    }

    public boolean isShooting() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING);
    }

    public void setShooting(boolean flag) {
        if (flag && !this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(CRASH_POS, (Object)this.m_20183_());
        }
        this.f_19804_.m_135381_(SHOOTING, (Object)flag);
    }

    public boolean isStunned() {
        return this.getStunTime() > 0;
    }

    public void setStunned(boolean stunned) {
        if (!stunned) {
            this.setStunTime(0);
            if (this.getDungeon() != null) {
                Vec3 origin = this.getDungeon().originCoordinates();
                this.m_21566_().m_6849_(origin.f_82479_ - 16.0, origin.f_82480_ + 12.0, origin.f_82481_, 2.0);
            }
            return;
        }
        if (this.getDungeon() != null && !this.getDungeon().dungeonPlayers().isEmpty()) {
            this.randomizeTarget();
            if (this.m_5448_() != null) {
                int height = (int)Math.max(this.getDungeon() != null ? this.getDungeon().originCoordinates().m_7098_() : 0.0, (double)this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)this.m_20185_(), (int)this.m_20189_()));
                this.m_6021_(this.m_20185_(), height, this.m_20189_());
                if (!this.m_9236_().m_5776_()) {
                    this.f_19804_.m_135381_(CRASH_POS, (Object)this.m_20183_());
                }
            }
        }
        this.setStunTime(60);
        this.courseFlipped = this.f_19796_.m_188499_();
    }

    public float getShootAnimScale(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.shootAnimO, (float)this.shootAnim);
    }

    public float getInvisAnimScale(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.invisAnimO, (float)this.invisAnim);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.setStunned(true);
                break;
            }
            case 6: {
                float y = -Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                float x = -Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float dist = 1.0f - y;
                float yDist = 3.3f;
                for (int i = 0; i < 10; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, this.m_20185_() + (double)(x * dist), this.m_20186_() + (double)y + (double)yDist, this.m_20189_() + (double)(z * dist), this.f_19796_.m_188583_() * (double)0.2f, 0.5, this.f_19796_.m_188583_() * (double)0.2f);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123769_, true, this.m_20185_() + (double)(x * dist), this.m_20186_() + (double)y + (double)yDist, this.m_20189_() + (double)(z * dist), 0.0, 1.0, 0.0);
                }
                break;
            }
            case 7: {
                float dist = 2.0f;
                float x = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * -dist;
                float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * dist;
                for (int i = 0; i < 50; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.2 - (double)(x * 0.2f);
                    double d1 = this.f_19796_.m_188583_() * 0.2;
                    double d2 = this.f_19796_.m_188583_() * 0.2 - (double)(z * 0.2f);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, this.m_20185_() + (double)x + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)z + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
                }
                break;
            }
            case 8: {
                float y = -Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                float x = -Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float dist = 1.0f - y;
                float yDist = 3.3f;
                for (int i = 0; i < 8; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, this.m_20185_() + (double)(x * dist), this.m_20186_() + (double)y + (double)yDist, this.m_20189_() + (double)(z * dist), this.f_19796_.m_188583_() * (double)0.2f, 0.5, this.f_19796_.m_188583_() * (double)0.2f);
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123759_, true, this.m_20185_() + (double)(x * dist), this.m_20186_() + (double)y + (double)yDist, this.m_20189_() + (double)(z * dist), this.f_19796_.m_188583_() * (double)0.2f, 0.5, this.f_19796_.m_188583_() * (double)0.2f);
                }
                break;
            }
            case 9: {
                this.shootTime = 3;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public Component getBossName() {
        return (Component)this.f_19804_.m_135370_(BOSS_NAME);
    }

    public void setBossName(Component component) {
        this.f_19804_.m_135381_(BOSS_NAME, (Object)component);
        this.bossFight.m_6456_(component);
    }

    public BossRoomTracker<AerwhaleKingEntity> getDungeon() {
        return this.platinumDungeon;
    }

    public void setDungeon(BossRoomTracker<AerwhaleKingEntity> dungeon) {
        this.platinumDungeon = dungeon;
    }

    public int getDeathScore() {
        return this.f_20897_;
    }

    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    public BlockState convertBlock(BlockState state) {
        if (state.m_60713_(LCBlocks.locked_gale_stone)) {
            return LCBlocks.gale_stone.m_49966_();
        }
        if (state.m_60713_(LCBlocks.locked_light_gale_stone)) {
            return LCBlocks.light_gale_stone.m_49966_();
        }
        if (state.m_60713_(LCBlocks.trapped_gale_stone)) {
            return LCBlocks.gale_stone.m_49966_();
        }
        if (state.m_60713_(LCBlocks.trapped_light_gale_stone)) {
            return LCBlocks.light_gale_stone.m_49966_();
        }
        if (state.m_60713_(LCBlocks.boss_doorway_gale_stone) || state.m_60713_(LCBlocks.boss_doorway_light_gale_stone)) {
            return Blocks.f_50016_.m_49966_();
        }
        return null;
    }

    public void resetIdleSoundTime() {
        this.f_21363_ = -this.m_8100_();
    }

    protected int getWantedFogTime() {
        return 500;
    }

    public int m_8100_() {
        boolean fog;
        boolean bl = fog = this.getFogTime() > 0;
        return this.m_5912_() ? (fog ? 30 : 120) : 150;
    }

    public SoundEvent m_7515_() {
        if (this.isStunned() || this.hasTargetPos()) {
            return null;
        }
        boolean fog = this.getFogTime() > 0;
        this.m_9236_().m_6269_(null, (Entity)this, fog ? LCSounds.ENTITY_AERWHALE_KING_IDLE_DISTANT : LCSounds.ENTITY_AERWHALE_KING_IDLE, this.m_5720_(), this.m_6121_() + (float)(fog ? 1 : 0), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.8f);
        return null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return LCSounds.ENTITY_AERWHALE_KING_HURT;
    }

    protected SoundEvent m_5592_() {
        return LCSounds.ENTITY_AERWHALE_KING_DEATH;
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.53f;
    }

    public void m_6457_(@Nonnull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Display(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)pPlayer);
        if (this.getDungeon() != null && this.getDungeon().isPlayerTracked((Player)pPlayer)) {
            this.bossFight.m_6543_(pPlayer);
        }
    }

    public void m_6452_(@Nonnull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Remove(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)pPlayer);
        this.bossFight.m_6539_(pPlayer);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
            LCPlayer.ifPresent(serverPlayer, lcp -> {
                lcp.setKingFight(false);
                lcp.setFogTime(Math.min(lcp.getFogTime(), 40));
                lcp.syncDataToClient();
            });
        }
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.invisAnim <= 0.0f;
    }

    public static List<Vec3> createTowerOffsets(Vec3 pos, int offset) {
        ArrayList positions = Lists.newArrayList();
        int corner = offset - 4;
        pos = pos.m_193103_(Direction.Axis.Y, pos.f_82480_ + 12.0);
        positions.add(pos.m_231075_(Direction.NORTH, (double)offset));
        positions.add(pos.m_82520_((double)corner, 0.0, (double)(-corner)));
        positions.add(pos.m_231075_(Direction.EAST, (double)offset));
        positions.add(pos.m_82520_((double)corner, 0.0, (double)corner));
        positions.add(pos.m_231075_(Direction.SOUTH, (double)offset));
        positions.add(pos.m_82520_((double)(-corner), 0.0, (double)corner));
        positions.add(pos.m_231075_(Direction.WEST, (double)offset));
        positions.add(pos.m_82520_((double)(-corner), 0.0, (double)(-corner)));
        return positions;
    }

    protected boolean m_8028_() {
        return false;
    }

    class WhaleMovementController
    extends MoveControl {
        private AerwhaleKingEntity boss;

        public WhaleMovementController(AerwhaleKingEntity whaleBoss) {
            super((Mob)whaleBoss);
            this.boss = AerwhaleKingEntity.this;
        }

        public void m_8126_() {
            if (this.boss.m_9236_().m_5776_()) {
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double d0 = this.f_24975_ - this.boss.m_20185_();
                double d1 = this.f_24976_ - this.boss.m_20186_();
                double d2 = this.f_24977_ - this.boss.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)Mth.m_14116_((float)((float)d3))) < this.boss.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else {
                    this.boss.m_20256_(this.boss.m_20184_().m_82520_(d0 / d3 * 0.05 * this.f_24978_, d1 / d3 * 0.05 * this.f_24978_, d2 / d3 * 0.05 * this.f_24978_));
                    if (!this.boss.hasTargetPos()) {
                        this.boss.m_146922_(Mth.m_14189_((float)0.5f, (float)this.boss.m_146908_(), (float)(-((float)Mth.m_14136_((double)this.boss.m_20184_().m_7096_(), (double)this.boss.m_20184_().m_7094_())) * 57.295776f)));
                        this.boss.f_20883_ = this.boss.m_146908_();
                    }
                }
            }
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return AerwhaleKingEntity.this.isStunned();
        }
    }

    class SpreadFogGoal
    extends Goal {
        private final AerwhaleKingEntity boss;
        private int chargeTime;

        public SpreadFogGoal() {
            this.boss = AerwhaleKingEntity.this;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.boss.m_5448_() == null || this.boss.getDungeon() == null || this.boss.hasTargetPos()) {
                return false;
            }
            if (this.boss.m_20186_() < this.boss.getDungeon().originCoordinates().m_7098_() + 13.0) {
                return false;
            }
            return !this.boss.isStunned() && this.boss.fogCooldown == 0;
        }

        public boolean m_8045_() {
            return this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned();
        }

        public void m_8056_() {
            this.chargeTime = 80;
            this.boss.setShooting(true);
            this.boss.m_5496_(LCSounds.ENTITY_AERWHALE_KING_SPOUT_FOG, this.boss.m_6121_(), (this.boss.f_19796_.m_188501_() - this.boss.f_19796_.m_188501_()) * 0.1f + 1.0f);
            this.setFogStatus(true);
            this.boss.fogCooldown = this.boss.getWantedFogTime() * 2;
            this.boss.m_9236_().m_7605_((Entity)this.boss, (byte)9);
            this.boss.resetIdleSoundTime();
        }

        public void m_8037_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.boss.m_21563_().m_24950_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 80.0f, 40.0f);
            this.boss.m_20256_(Vec3.f_82478_);
            this.boss.m_9236_().m_7605_((Entity)this.boss, (byte)8);
        }

        public void m_8041_() {
            this.boss.setShooting(false);
            this.boss.fogCooldown = this.boss.getWantedFogTime() * 2;
        }

        private void setFogStatus(boolean status) {
            int time = this.boss.getWantedFogTime();
            this.boss.setFogTime(time);
            if (this.boss.getDungeon() != null) {
                this.boss.getDungeon().dungeonPlayers().stream().map(uuid -> this.boss.m_9236_().m_46003_(uuid)).filter(p -> p != null && !p.m_213877_() && EntitySelector.f_20406_.test(p)).forEach(p -> LCPlayer.ifPresent(p, lcp -> lcp.setFogTime(time)));
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class ShootTargetGoal
    extends Goal {
        private final AerwhaleKingEntity boss;
        private int chargeTime;

        public ShootTargetGoal() {
            this.boss = AerwhaleKingEntity.this;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.boss.m_5448_() == null || this.boss.getDungeon() == null || this.boss.hasTargetPos()) {
                return false;
            }
            if (this.boss.m_20186_() < this.boss.getDungeon().originCoordinates().m_7098_() + 13.0) {
                return false;
            }
            return !this.boss.isStunned() && this.boss.shootCooldown == 0 && this.boss.fogCooldown > 3;
        }

        public boolean m_8045_() {
            return this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned();
        }

        public void m_8056_() {
            this.chargeTime = 40 + this.boss.f_19796_.m_188503_(2) * 10;
            this.boss.setShooting(true);
        }

        public void m_8037_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            Level level = this.boss.m_9236_();
            this.boss.m_21563_().m_24950_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 80.0f, 40.0f);
            this.boss.m_20256_(Vec3.f_82478_);
            if (this.chargeTime >= 10 && this.chargeTime % (this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f ? 5 : 10) == 0) {
                CloudShotEntity cloudShot = new CloudShotEntity(level, (LivingEntity)this.boss);
                float yp = -Mth.m_14031_((float)(this.boss.m_146909_() * ((float)Math.PI / 180)));
                float xp = -Mth.m_14031_((float)(this.boss.f_20883_ * ((float)Math.PI / 180)));
                float zp = Mth.m_14089_((float)(this.boss.f_20883_ * ((float)Math.PI / 180)));
                float spawnDist = 1.0f - yp;
                float spawnDistY = 3.0f;
                cloudShot.m_6034_(this.boss.m_20185_() + (double)(xp * spawnDist), this.boss.m_20186_() + (double)yp + (double)spawnDistY, this.boss.m_20189_() + (double)(zp * spawnDist));
                float offset = this.boss.f_19796_.m_188501_() * 0.5f * 720.0f;
                int dist = 7 + this.boss.f_19796_.m_188503_(3);
                double x = (double)dist * Math.cos(offset);
                double z = (double)dist * Math.sin(offset);
                Vec3 pos = this.boss.getDungeon() != null ? this.boss.getDungeon().originCoordinates() : target.m_20182_();
                Vec3 offsetPos = pos.m_82520_(x, 0.0, z);
                double d0 = offsetPos.m_7096_() - cloudShot.m_20185_();
                double d1 = offsetPos.m_7098_() - (double)1.1f - cloudShot.m_20186_();
                double d2 = offsetPos.m_7094_() - cloudShot.m_20189_();
                float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 2.5f;
                cloudShot.m_6686_(d0, d1 + (double)f, d2, 0.65f, 0.0f);
                level.m_7967_((Entity)cloudShot);
                this.boss.m_5496_(LCSounds.ENTITY_AERWHALE_KING_SHOOT, this.boss.m_6121_(), (this.boss.f_19796_.m_188501_() - this.boss.f_19796_.m_188501_()) * 0.2f + 1.0f);
                level.m_7605_((Entity)this.boss, (byte)6);
                level.m_7605_((Entity)this.boss, (byte)9);
            }
        }

        public void m_8041_() {
            this.boss.setShooting(false);
            this.boss.shootCooldown = 180;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class ChargeTargetGoal
    extends Goal {
        private final AerwhaleKingEntity boss;
        private int chargeTime;
        private Vec3 nextPos;
        private Vec3 finalTargetPos;
        private boolean flipped;
        private boolean hitLanded;
        private boolean shouldCancel;
        private List<Vec3> surroundingPos;

        public ChargeTargetGoal() {
            this.boss = AerwhaleKingEntity.this;
            this.surroundingPos = new ArrayList<Vec3>();
        }

        public boolean m_8036_() {
            if (this.boss.m_5448_() == null || this.boss.getDungeon() == null) {
                return false;
            }
            return !this.boss.isShooting() && !this.boss.isStunned();
        }

        public boolean m_8045_() {
            return this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned();
        }

        public void m_8056_() {
            this.finalTargetPos = null;
            this.surroundingPos = AerwhaleKingEntity.createTowerOffsets(this.boss.getDungeon().originCoordinates(), 16);
            this.nextPos = this.surroundingPos.get(this.boss.courseIndex);
            this.chargeTime = 100 + 20 * this.boss.f_19796_.m_188503_(5);
            if (this.boss.getFogTime() > 0) {
                this.chargeTime += 30;
            }
            this.hitLanded = false;
            this.flipped = this.boss.f_19796_.m_188499_();
            this.shouldCancel = this.boss.f_19796_.m_188501_() < 0.75f;
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.boss.isShooting() && this.boss.getFogTime() >= this.boss.getWantedFogTime()) {
                this.chargeTime += 60;
            }
            if ((target = this.boss.m_5448_()) == null || this.boss.isShooting()) {
                return;
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            Level level = this.boss.m_9236_();
            double flySpeed = 1.5;
            if (this.chargeTime <= 33 && this.finalTargetPos == null) {
                this.finalTargetPos = target.m_20182_();
                this.boss.f_21344_.m_26573_();
            }
            if (this.chargeTime > 30) {
                if (this.nextPos != null) {
                    this.boss.m_21566_().m_6849_(this.nextPos.f_82479_, this.nextPos.f_82480_, this.nextPos.f_82481_, flySpeed);
                }
                float dist = 3.0f;
                float x = Mth.m_14031_((float)(this.boss.f_20883_ * ((float)Math.PI / 180))) * -dist;
                float z = Mth.m_14089_((float)(this.boss.f_20883_ * ((float)Math.PI / 180))) * dist;
                Vec3 p = new Vec3(this.boss.m_20185_() + (double)x, Math.max(this.nextPos.f_82480_ + (double)(this.boss.m_20192_() * 0.7f), this.boss.m_20188_()), this.boss.m_20189_() + (double)z);
                this.boss.m_21563_().m_24950_(p.f_82479_, p.f_82480_, p.f_82481_, (float)(this.boss.m_8085_() * 4), 30.0f);
                if (Mth.m_14116_((float)((float)this.boss.m_20238_(this.nextPos))) <= 4.0f) {
                    if (this.flipped) {
                        if (--this.boss.courseIndex < 0) {
                            this.boss.courseIndex = 7;
                        }
                    } else if (++this.boss.courseIndex >= 8) {
                        this.boss.courseIndex = 0;
                    }
                    this.nextPos = this.surroundingPos.get(this.boss.courseIndex);
                }
            } else if (this.finalTargetPos != null) {
                boolean fireParticles = false;
                if (!this.boss.hasTargetPos()) {
                    this.boss.m_9236_().m_6269_(null, (Entity)this.boss, LCSounds.ENTITY_AERWHALE_KING_CHARGE, this.boss.m_5720_(), this.boss.m_6121_(), (this.boss.f_19796_.m_188501_() - this.boss.f_19796_.m_188501_()) * 0.05f + 1.0f);
                    this.boss.m_20256_(Vec3.f_82478_);
                    fireParticles = true;
                }
                this.boss.setPosTargetted(true);
                this.boss.m_21563_().m_24950_(this.finalTargetPos.f_82479_, this.finalTargetPos.f_82480_, this.finalTargetPos.f_82481_, (float)(this.boss.m_8085_() * 8), (float)(this.boss.m_8132_() * 4));
                this.boss.m_21566_().m_6849_(this.finalTargetPos.f_82479_, this.finalTargetPos.f_82480_, this.finalTargetPos.f_82481_, 10.0);
                if (fireParticles) {
                    level.m_7605_((Entity)this.boss, (byte)7);
                }
                List list = level.m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_((double)0.7f));
                boolean hit = false;
                for (Entity entity : list) {
                    if (this.boss.isStunned()) {
                        return;
                    }
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (living.f_20916_ > 0 || living.m_7307_((Entity)this.boss) || !this.boss.m_7327_((Entity)living)) continue;
                    living.m_5997_(living.m_20184_().m_7098_() * 2.0, 0.35, living.m_20184_().m_7094_() * 2.0);
                    this.boss.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_SHOOT.get(), 2.5f, 1.0f / (this.boss.f_19796_.m_188501_() * 0.1f + 0.7f));
                    hit = true;
                }
                if (!this.hitLanded) {
                    this.hitLanded = hit;
                }
                if (this.hitLanded) {
                    this.boss.m_20256_(this.boss.m_20184_().m_82520_(0.0, 1.5, 0.0));
                    this.boss.f_19864_ = true;
                    this.chargeTime = 0;
                }
                if (!this.hitLanded && !this.boss.isStunned() && this.boss.m_20191_().m_82400_(1.0).m_82390_(this.finalTargetPos)) {
                    this.boss.setStunned(true);
                    this.spawnRocks();
                }
            }
        }

        public void m_8041_() {
            int min;
            boolean canAllowMore = this.shouldCancel && this.hitLanded && !this.boss.isStunned();
            int n = min = canAllowMore ? 50 : 100;
            if (this.boss.shootCooldown < min) {
                this.boss.shootCooldown = min;
            }
            if (this.boss.fogCooldown < min) {
                this.boss.fogCooldown = min;
                this.boss.shootCooldown += 40;
            }
            this.boss.setPosTargetted(false);
            this.shouldCancel = false;
            this.hitLanded = false;
        }

        public boolean m_183429_() {
            return true;
        }

        private void spawnRocks() {
            double z;
            double x;
            float offset;
            Level level = this.boss.m_9236_();
            this.boss.m_21373_();
            level.m_254849_((Entity)this.boss, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
            Vec3 origin = this.boss.getDungeon().originCoordinates();
            for (int w = 0; w < 2 + level.f_46441_.m_188503_(2); ++w) {
                float whirlyDist = w >= 4 ? 9.0f : 7.0f;
                offset = level.f_46441_.m_188501_() * 180.0f * 2.0f;
                x = (double)whirlyDist * Math.cos(offset);
                z = (double)whirlyDist * Math.sin(offset);
                Vec3 pos = origin.m_82520_(x, 0.0, z);
                PassiveWhirlwind whirly = new PassiveWhirlwind((EntityType)AetherEntityTypes.WHIRLWIND.get(), level);
                whirly.m_6027_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                whirly.setLifeLeft(100 + level.f_46441_.m_188503_(2) * 20);
                ((AbstractWhirlwindAccessor)whirly).setDropsTimer(-2147483647);
                level.m_7967_((Entity)whirly);
            }
            float dist = 1.5f;
            for (int w = 0; w < 10; ++w) {
                offset = level.f_46441_.m_188501_() * 360.0f;
                x = (double)dist * Math.cos(offset);
                z = (double)dist * Math.sin(offset);
                boolean targetBound = w == 0 && this.boss.m_5448_() != null;
                Vec3 offsetVec = this.boss.m_20182_().m_82520_(x, 0.0, z);
                FallingRockEntity projectile = new FallingRockEntity(level, (LivingEntity)this.boss);
                projectile.m_6027_(offsetVec.f_82479_, offsetVec.f_82480_, offsetVec.f_82481_);
                if (targetBound) {
                    offsetVec = this.boss.m_5448_().m_20182_();
                }
                double xc = (targetBound ? projectile.m_20182_().f_82479_ : this.boss.m_20182_().f_82479_) - offsetVec.f_82479_;
                double zc = (targetBound ? projectile.m_20182_().f_82481_ : this.boss.m_20182_().f_82481_) - offsetVec.f_82481_;
                float vertMul = targetBound ? 0.1f : 0.25f;
                projectile.m_20334_(xc * (double)(-vertMul), 0.28f + level.f_46441_.m_188501_() * 0.05f, zc * (double)(-vertMul));
                this.boss.m_9236_().m_7967_((Entity)projectile);
            }
        }
    }

    class RunIdleCourseGoal
    extends Goal {
        private final AerwhaleKingEntity boss;
        private Vec3 nextPos;
        private List<Vec3> surroundingPos;

        public RunIdleCourseGoal() {
            this.boss = AerwhaleKingEntity.this;
            this.surroundingPos = new ArrayList<Vec3>();
        }

        public boolean m_8036_() {
            return this.boss.getDungeon() != null && !this.boss.isStunned() && this.boss.m_5448_() == null;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.surroundingPos = AerwhaleKingEntity.createTowerOffsets(this.boss.getDungeon().originCoordinates(), 14);
            this.nextPos = this.surroundingPos.get(this.boss.courseIndex);
        }

        public void m_8037_() {
            double flySpeed;
            double d = flySpeed = this.boss.isBossFight() ? 1.0 : (double)0.7f;
            if (this.nextPos != null) {
                this.boss.m_21566_().m_6849_(this.nextPos.f_82479_, this.nextPos.f_82480_, this.nextPos.f_82481_, flySpeed);
            }
            if (Mth.m_14116_((float)((float)this.boss.m_20238_(this.nextPos))) <= 4.0f) {
                if (++this.boss.courseIndex >= 8) {
                    this.boss.courseIndex = 0;
                }
                this.nextPos = this.surroundingPos.get(this.boss.courseIndex);
            }
        }

        public void m_8041_() {
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

