/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.data;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.data.LCTags;
import com.legacy.lost_aether.registry.LCBlocks;
import com.legacy.lost_aether.registry.LCEntityTypes;
import com.legacy.lost_aether.registry.LCItems;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaEntityLoot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class LCLootProv
extends LootTableProvider {
    public static final ResourceLocation PLATINUM_DUNGEON_LOOT = LostContentMod.locate("chests/platinum_dungeon_loot");
    public static final ResourceLocation PLATINUM_TREASURE_LOOT = LostContentMod.locate("chests/platinum_treasure_loot");

    public LCLootProv(DataGenerator gen, ExistingFileHelper fileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
        super(gen.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(ChestGen::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(BlockGen::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(EntityGen::new, LootContextParamSets.f_81415_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.m_79147_();
            pools.forEach(pool -> table.m_79161_(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.m_79147_().m_79161_(pool);
        }

        default public LootPool.Builder basicPool(ItemLike item, int min, int max) {
            return LootPool.m_79043_().m_79076_(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(ItemLike item) {
            return LootPool.m_79043_().m_79076_(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<ItemLike> items) {
            return this.poolOf(items.stream().map(i -> this.basicEntry((ItemLike)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootPoolEntryContainer.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.m_79043_();
            lootEntries.forEach(entry -> pool.m_79076_(entry));
            return pool;
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item, int min, int max) {
            return this.basicEntry(item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item) {
            return LootItem.m_79579_((ItemLike)item);
        }

        default public LootItemConditionalFunction.Builder<?> setDamage(int min, int max) {
            return SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)((float)min / 100.0f), (float)((float)max / 100.0f)));
        }

        default public LootItemConditionalFunction.Builder<?> smeltItem(EntityPredicate.Builder predicate) {
            return SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)predicate));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(int minLevel, int maxLevel) {
            return EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)minLevel, (float)maxLevel));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(Enchantment ... enchantments) {
            EnchantRandomlyFunction.Builder func = new EnchantRandomlyFunction.Builder();
            for (Enchantment enchantment : enchantments) {
                func.m_80444_(enchantment);
            }
            return func;
        }

        default public LootItemConditionalFunction.Builder<?> setNbt(Consumer<CompoundTag> nbt) {
            return SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt)));
        }
    }

    public static class ChestGen
    implements LootPoolUtil,
    LootTableSubProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder normalLoot = this.poolOf(List.of(this.basicEntry((ItemLike)AetherItems.ZANITE_GEMSTONE.get(), 2, 3).m_79707_(3), this.basicEntry((ItemLike)AetherBlocks.COLD_AERCLOUD.get(), 4, 8).m_79707_(5), this.basicEntry((ItemLike)AetherItems.ENCHANTED_DART.get(), 5, 8).m_79707_(4), this.basicEntry((ItemLike)AetherItems.WHITE_APPLE.get(), 2, 3).m_79707_(5), this.basicEntry((ItemLike)LCBlocks.crystal_sapling, 1, 2).m_79707_(4), this.basicEntry((ItemLike)LCBlocks.holiday_sapling).m_79707_(1), this.basicEntry((ItemLike)LCItems.brown_moa_egg).m_79707_(1), this.basicEntry((ItemLike)AetherItems.WHITE_CAPE.get()).m_79707_(2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f));
            consumer.accept(PLATINUM_DUNGEON_LOOT, this.tableOf(List.of(normalLoot)));
            LootPool.Builder tool = this.poolOf(List.of(TagEntry.m_205095_(LCTags.Items.PHOENIX_TOOLS)));
            LootPool.Builder disc = this.poolOf(List.of(this.basicEntry((ItemLike)LCItems.music_disc_sovereign_of_the_skies), this.basicEntry((ItemLike)LCItems.music_disc_legacy)));
            LootPool.Builder trims = this.poolOf(List.of(this.basicEntry((ItemLike)LCItems.noble_trim)));
            LootPool.Builder realLoot = this.poolOf(List.of(this.basicEntry((ItemLike)AetherItems.LIFE_SHARD.get()).m_79707_(4), this.basicEntry((ItemLike)LCItems.shield_of_emile).m_79707_(3), this.basicEntry((ItemLike)LCItems.power_gloves).m_79707_(4), this.basicEntry((ItemLike)LCItems.phoenix_cape).m_79707_(3), this.basicEntry((ItemLike)LCItems.invincibility_gem).m_79707_(2), this.basicEntry((ItemLike)LCItems.sentry_shield).m_79707_(4), this.basicEntry((ItemLike)LCItems.agility_boots).m_79707_(3), this.basicEntry((ItemLike)LCItems.flaming_gemstone).m_79707_(5), this.basicEntry((ItemLike)LCItems.swetty_mask).m_79707_(2), this.basicEntry((ItemLike)AetherItems.CLOUD_STAFF.get()).m_79707_(2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f));
            LootPool.Builder filler = this.poolOf(List.of(this.basicEntry((ItemLike)AetherBlocks.ENCHANTED_GRAVITITE.get(), 1, 3).m_79707_(2), this.basicEntry((ItemLike)LCBlocks.enchanted_pink_aercloud, 2, 3).m_79707_(5), this.basicEntry((ItemLike)AetherBlocks.BLUE_AERCLOUD.get(), 2, 3).m_79707_(7), this.basicEntry((ItemLike)AetherItems.ENCHANTED_DART.get(), 10, 16).m_79707_(9))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)5.0f));
            consumer.accept(PLATINUM_TREASURE_LOOT, this.tableOf(List.of(tool, realLoot, disc, filler, trims)));
        }
    }

    private static class EntityGen
    extends VanillaEntityLoot
    implements LootPoolUtil {
        private EntityGen() {
        }

        public void m_246942_() {
            LootPool.Builder cloud = this.lootingPool((ItemLike)AetherBlocks.BLUE_AERCLOUD.get(), 2, 4, 0, 2);
            this.m_245309_(LCEntityTypes.AERWHALE_KING, this.tableOf(List.of(cloud, this.basicPool((ItemLike)LCItems.platinum_key))));
        }

        private LootPool.Builder lootingPool(ItemLike item, int min, int max, int minLooting, int maxLooting) {
            return this.basicPool(item, min, max).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)minLooting, (float)maxLooting)));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(e -> ForgeRegistries.ENTITY_TYPES.getKey(e).m_135827_().contains("lost_aether_content"));
        }
    }

    private static class BlockGen
    extends BlockLootSubProvider {
        protected BlockGen() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.blocks().forEach(block -> {
                if (block instanceof SlabBlock) {
                    this.m_247577_((Block)block, this.m_247233_((Block)block));
                } else if (block instanceof FlowerPotBlock) {
                    this.m_246535_((Block)block);
                } else {
                    this.m_245724_((Block)block);
                }
            });
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        private Stream<Block> blocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> ForgeRegistries.BLOCKS.getKey(b).m_135827_().equals("lost_aether_content") && !b.m_60589_().equals((Object)BuiltInLootTables.f_78712_));
        }
    }
}

