/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootTables;
import vazkii.botania.xplat.XplatAbstractions;

public class LooniumBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int CHECK_RANGE = 9;
    private static final String TAG_LOOT_TABLE = "lootTable";
    private static final String TAG_DETECTED_STRUCTURE = "detectedStructure";
    private static final String TAG_CONFIG_OVERRIDE = "configOverride";
    private static final String TAG_ATTUNE_DISPLAY_OVERRIDE = "attuneDisplayOverride";
    private static final Supplier<LooniumStructureConfiguration> FALLBACK_CONFIG = Suppliers.memoize(() -> LooniumStructureConfiguration.builder().manaCost(35000).maxNearbyMobs(10).boundingBoxType(StructureSpawnOverride.BoundingBoxType.PIECE).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 1).build()).attributeModifiers(new LooniumMobAttributeModifier[0]).effectsToApply(LooniumMobEffectToApply.effect(MobEffects.f_19605_).build(), LooniumMobEffectToApply.effect(MobEffects.f_19607_).build(), LooniumMobEffectToApply.effect(MobEffects.f_19606_).build(), LooniumMobEffectToApply.effect(MobEffects.f_19600_).build()).build());
    public static final String LOONIUM_TEAM_NAME = "Loonium Monsters";
    public static final Team LOONIUM_TEAM = new Team(){

        @NotNull
        public String m_5758_() {
            return LooniumBlockEntity.LOONIUM_TEAM_NAME;
        }

        @NotNull
        public MutableComponent m_6870_(Component component) {
            return component.m_6881_();
        }

        public boolean m_6259_() {
            return true;
        }

        public boolean m_6260_() {
            return true;
        }

        @NotNull
        public Team.Visibility m_7470_() {
            return Team.Visibility.ALWAYS;
        }

        @NotNull
        public ChatFormatting m_7414_() {
            return ChatFormatting.RESET;
        }

        @NotNull
        public Collection<String> m_6809_() {
            return List.of();
        }

        @NotNull
        public Team.Visibility m_7468_() {
            return Team.Visibility.ALWAYS;
        }

        @NotNull
        public Team.CollisionRule m_7156_() {
            return Team.CollisionRule.ALWAYS;
        }
    };
    @Nullable
    private ResourceLocation lootTableOverride;
    @Nullable
    private Object2BooleanMap<ResourceLocation> detectedStructures;
    @Nullable
    private ResourceLocation configOverride;
    @Nullable
    private String attuneDisplayOverride;

    public LooniumBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.LOONIUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (this.detectedStructures == null) {
            this.detectStructure(world);
        }
        if (this.redstoneSignal != 0 || this.ticksExisted % 100 != 0 || world.m_46791_() == Difficulty.PEACEFUL || !world.m_143340_(this.getEffectivePos())) {
            return;
        }
        ConfigDataManager configData = BotaniaAPI.instance().getConfigData();
        Map<ResourceLocation, LooniumStructureConfiguration> structureConfigs = this.determineStructureConfigs(configData, this.detectedStructures);
        List<Pair<ResourceLocation, LootTable>> lootTables = this.determineLootTables(world, structureConfigs.keySet());
        if (lootTables.isEmpty()) {
            return;
        }
        Pair<ResourceLocation, LootTable> randomPick = lootTables.get(world.f_46441_.m_188503_(lootTables.size()));
        LooniumStructureConfiguration pickedConfig = structureConfigs.getOrDefault(randomPick.key(), structureConfigs.get(LooniumStructureConfiguration.DEFAULT_CONFIG_ID));
        LootTable pickedLootTable = (LootTable)randomPick.value();
        if (this.getMana() < pickedConfig.manaCost) {
            return;
        }
        int numberOfMobsAround = this.countNearbyMobs(world, pickedConfig);
        if (numberOfMobsAround >= pickedConfig.maxNearbyMobs) {
            return;
        }
        LooniumMobSpawnData pickedMobType = pickedConfig.spawnedMobs.m_216829_(world.f_46441_).orElse(null);
        if (pickedMobType == null) {
            return;
        }
        this.spawnMob(world, pickedMobType, pickedConfig, pickedLootTable);
    }

    private void spawnMob(ServerLevel world, LooniumMobSpawnData pickedMobType, LooniumStructureConfiguration pickedConfig, LootTable pickedLootTable) {
        LootTable equipmentTable;
        ItemStack lootStack = LooniumBlockEntity.pickRandomLootItem(world, pickedLootTable);
        if (lootStack.m_41619_()) {
            return;
        }
        RandomSource random = world.f_46441_;
        double x = (double)this.getEffectivePos().m_123341_() + 0.5 - 5.0 + 10.0 * random.m_188500_();
        double y = this.getEffectivePos().m_123342_();
        double z = (double)this.getEffectivePos().m_123343_() + 0.5 - 5.0 + 10.0 * random.m_188500_();
        while (!world.m_45772_(pickedMobType.type.m_20585_(x, y, z))) {
            if (!((y += 1.0) >= (double)world.m_151558_())) continue;
            return;
        }
        Entity entity = pickedMobType.type.m_20615_((Level)world);
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (pickedMobType.nbt != null) {
            mob.m_7378_(pickedMobType.nbt);
        }
        if (pickedMobType.spawnAsBaby != null) {
            mob.m_6863_(pickedMobType.spawnAsBaby.booleanValue());
        }
        mob.m_19890_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
        mob.m_20256_(Vec3.f_82478_);
        LooniumBlockEntity.applyAttributesAndEffects(pickedMobType, pickedConfig, mob);
        LooniumComponent looniumComponent = XplatAbstractions.INSTANCE.looniumComponent((LivingEntity)mob);
        if (looniumComponent != null) {
            looniumComponent.setSlowDespawn(true);
            looniumComponent.setOverrideDrop(true);
            looniumComponent.setDrop(lootStack);
        }
        mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, null, null);
        if (Boolean.FALSE.equals(pickedMobType.spawnAsBaby) && mob.m_6162_()) {
            mob.m_6863_(false);
        }
        if (pickedMobType.equipmentTable != null && (equipmentTable = world.m_7654_().m_278653_().m_278676_(pickedMobType.equipmentTable)) != LootTable.f_79105_) {
            LootParams lootParams = new LootParams.Builder(world).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81460_, (Object)mob.m_20182_()).m_287235_(LootContextParamSets.f_81413_);
            HashSet equippedSlots = new HashSet();
            equipmentTable.m_287228_(lootParams, equipmentStack -> {
                EquipmentSlot slot;
                EquipmentSlot equipmentSlot = slot = equipmentStack.m_204117_(BotaniaTags.Items.LOONIUM_OFFHAND_EQUIPMENT) ? EquipmentSlot.OFFHAND : LivingEntity.m_147233_((ItemStack)equipmentStack);
                if (equippedSlots.contains(slot)) {
                    EquipmentSlot equipmentSlot2 = slot = equippedSlots.contains(EquipmentSlot.MAINHAND) && !(equipmentStack.m_41720_() instanceof TieredItem) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                }
                if (!equippedSlots.add(slot)) {
                    return;
                }
                mob.m_8061_(slot, slot.m_254934_() ? equipmentStack.m_255036_(1) : equipmentStack);
            });
        }
        mob.m_20201_().m_142429_().forEach(e -> {
            if (e instanceof Mob) {
                ItemStack bonusLoot;
                PatrollingMonster patroller;
                Mob otherMob = (Mob)e;
                Arrays.stream(EquipmentSlot.values()).forEach(slot -> otherMob.m_21409_(slot, 0.0f));
                if (mob instanceof PatrollingMonster && (patroller = (PatrollingMonster)mob).m_33067_()) {
                    patroller.m_33075_(false);
                    patroller.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                }
                if (e == mob) {
                    return;
                }
                Optional<LooniumMobSpawnData> mobType = pickedConfig.spawnedMobs.m_146338_().stream().filter(mobSpawnData -> mobSpawnData.type.m_141992_((Entity)otherMob) != null).findFirst();
                if (mobType.isPresent()) {
                    LooniumBlockEntity.applyAttributesAndEffects(mobType.get(), pickedConfig, mob);
                    bonusLoot = LooniumBlockEntity.pickRandomLootItem(world, pickedLootTable);
                } else {
                    bonusLoot = ItemStack.f_41583_;
                }
                LooniumComponent otherLooniumComponent = XplatAbstractions.INSTANCE.looniumComponent((LivingEntity)otherMob);
                if (otherLooniumComponent != null) {
                    otherLooniumComponent.setSlowDespawn(true);
                    otherLooniumComponent.setOverrideDrop(true);
                    otherLooniumComponent.setDrop(bonusLoot);
                }
            }
        });
        if (!world.m_8860_((Entity)mob)) {
            return;
        }
        mob.m_21373_();
        world.m_46796_(2004, this.m_58899_(), 0);
        world.m_220400_((Entity)mob, GameEvent.f_157810_, mob.m_20182_());
        this.addMana(-pickedConfig.manaCost.intValue());
        this.sync();
    }

    private static void applyAttributesAndEffects(LooniumMobSpawnData mobSpawnData, LooniumStructureConfiguration pickedConfig, Mob mob) {
        List<LooniumMobAttributeModifier> attributeModifiers = mobSpawnData.attributeModifiers != null ? mobSpawnData.attributeModifiers : pickedConfig.attributeModifiers;
        for (LooniumMobAttributeModifier attributeModifier : attributeModifiers) {
            AttributeInstance attribute = mob.m_21051_(attributeModifier.attribute);
            if (attribute == null) continue;
            attribute.m_22125_(attributeModifier.createAttributeModifier());
            if (attribute.m_22099_() != Attributes.f_22276_) continue;
            mob.m_21153_(mob.m_21233_());
        }
        List<LooniumMobEffectToApply> effectsToApply = mobSpawnData.effectsToApply != null ? mobSpawnData.effectsToApply : pickedConfig.effectsToApply;
        for (LooniumMobEffectToApply effectToApply : effectsToApply) {
            mob.m_7292_(effectToApply.createMobEffectInstance());
        }
    }

    private int countNearbyMobs(ServerLevel world, LooniumStructureConfiguration pickedConfig) {
        Set setOfMobTypes = pickedConfig.spawnedMobs.m_146338_().stream().map(msd -> msd.type).collect(Collectors.toSet());
        return world.m_6443_(Mob.class, new AABB(this.getEffectivePos()).m_82400_(9.0), m -> setOfMobTypes.contains(m.m_6095_())).size();
    }

    private static ItemStack pickRandomLootItem(ServerLevel world, LootTable pickedLootTable) {
        LootParams params = new LootParams.Builder(world).m_287235_(LootContextParamSets.f_81410_);
        ObjectArrayList stacks = pickedLootTable.m_287214_(params, world.f_46441_.m_188505_());
        stacks.removeIf(s -> s.m_41619_() || s.m_204117_(BotaniaTags.Items.LOONIUM_BLACKLIST));
        if (stacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Collections.shuffle(stacks);
        return (ItemStack)stacks.get(0);
    }

    @NotNull
    private List<Pair<ResourceLocation, LootTable>> determineLootTables(ServerLevel world, Set<ResourceLocation> structureIds) {
        LootTable defaultLootTable;
        ArrayList<Pair<ResourceLocation, LootTable>> lootTables = new ArrayList<Pair<ResourceLocation, LootTable>>();
        LootDataManager lootData = world.m_7654_().m_278653_();
        com.google.common.base.Supplier defaultLootTableSupplier = Suppliers.memoize(() -> lootData.m_278676_(BotaniaLootTables.LOONIUM_DEFAULT_LOOT));
        if (this.lootTableOverride != null) {
            LootTable lootTable = lootData.m_278676_(this.lootTableOverride);
            if (lootTable != LootTable.f_79105_) {
                lootTables.add((Pair<ResourceLocation, LootTable>)Pair.of((Object)LooniumStructureConfiguration.DEFAULT_CONFIG_ID, (Object)lootTable));
            }
        } else {
            for (ResourceLocation structureId : structureIds) {
                if (structureId.equals((Object)LooniumStructureConfiguration.DEFAULT_CONFIG_ID)) continue;
                ResourceLocation lootTableId = ResourceLocationHelper.prefix("loonium/%s/%s".formatted(structureId.m_135827_(), structureId.m_135815_()));
                LootTable lootTable = lootData.m_278676_(lootTableId);
                if (lootTable != LootTable.f_79105_) {
                    lootTables.add((Pair<ResourceLocation, LootTable>)Pair.of((Object)structureId, (Object)lootTable));
                    continue;
                }
                LootTable defaultLootTable2 = (LootTable)defaultLootTableSupplier.get();
                if (defaultLootTable2 == LootTable.f_79105_) continue;
                lootTables.add((Pair<ResourceLocation, LootTable>)Pair.of((Object)structureId, (Object)defaultLootTable2));
            }
        }
        if (lootTables.isEmpty() && (defaultLootTable = (LootTable)defaultLootTableSupplier.get()) != LootTable.f_79105_) {
            lootTables.add((Pair<ResourceLocation, LootTable>)Pair.of((Object)LooniumStructureConfiguration.DEFAULT_CONFIG_ID, (Object)defaultLootTable));
        }
        return lootTables;
    }

    @NotNull
    private Map<ResourceLocation, LooniumStructureConfiguration> determineStructureConfigs(@NotNull ConfigDataManager configData, @NotNull Object2BooleanMap<ResourceLocation> structures) {
        if (this.configOverride != null) {
            LooniumStructureConfiguration overrideConfig = configData.getEffectiveLooniumStructureConfiguration(this.configOverride);
            return Map.of(LooniumStructureConfiguration.DEFAULT_CONFIG_ID, overrideConfig != null ? overrideConfig : LooniumBlockEntity.getDefaultConfig(configData));
        }
        LooniumStructureConfiguration defaultConfig = LooniumBlockEntity.getDefaultConfig(configData);
        HashMap<ResourceLocation, LooniumStructureConfiguration> structureConfigs = new HashMap<ResourceLocation, LooniumStructureConfiguration>();
        for (Object2BooleanMap.Entry structureEntry : structures.object2BooleanEntrySet()) {
            LooniumStructureConfiguration structureSpecificConfig = configData.getEffectiveLooniumStructureConfiguration((ResourceLocation)structureEntry.getKey());
            LooniumStructureConfiguration structureConfig = structureSpecificConfig != null ? structureSpecificConfig : defaultConfig;
            if (structureConfig == null || !structureEntry.getBooleanValue() && structureConfig.boundingBoxType != StructureSpawnOverride.BoundingBoxType.STRUCTURE) continue;
            structureConfigs.put((ResourceLocation)structureEntry.getKey(), structureConfig);
        }
        structureConfigs.put(LooniumStructureConfiguration.DEFAULT_CONFIG_ID, defaultConfig);
        return structureConfigs;
    }

    private static LooniumStructureConfiguration getDefaultConfig(ConfigDataManager configData) {
        LooniumStructureConfiguration defaultConfig = configData.getEffectiveLooniumStructureConfiguration(LooniumStructureConfiguration.DEFAULT_CONFIG_ID);
        return defaultConfig != null ? defaultConfig : FALLBACK_CONFIG.get();
    }

    private void detectStructure(ServerLevel world) {
        Object2BooleanRBTreeMap structureMap = new Object2BooleanRBTreeMap();
        StructureManager structureManager = world.m_215010_();
        BlockPos pos = this.m_58899_();
        Map structures = structureManager.m_220522_(pos);
        for (Map.Entry entry : structures.entrySet()) {
            Structure structure = (Structure)entry.getKey();
            StructureStart start = structureManager.m_220494_(pos, structure);
            if (!start.m_73603_()) continue;
            ResourceLocation structureId = world.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)structure);
            boolean insidePiece = structureManager.m_220497_(pos, start);
            if (!insidePiece && structureMap.getBoolean((Object)structureId)) continue;
            structureMap.put((Object)structureId, insidePiece);
        }
        this.detectedStructures = new Object2BooleanArrayMap((Object2BooleanMap)structureMap);
        this.m_6596_();
        this.sync();
    }

    @Override
    public int getColor() {
        return 12754274;
    }

    @Override
    public int getMaxMana() {
        return 35000;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 9);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.m_128441_(TAG_LOOT_TABLE)) {
            this.lootTableOverride = new ResourceLocation(cmp.m_128461_(TAG_LOOT_TABLE));
        }
        if (cmp.m_128441_(TAG_CONFIG_OVERRIDE)) {
            this.configOverride = new ResourceLocation(cmp.m_128461_(TAG_CONFIG_OVERRIDE));
        }
        if (cmp.m_128441_(TAG_ATTUNE_DISPLAY_OVERRIDE)) {
            this.attuneDisplayOverride = cmp.m_128461_(TAG_ATTUNE_DISPLAY_OVERRIDE);
        }
        if (cmp.m_128441_(TAG_DETECTED_STRUCTURE)) {
            String rawString = cmp.m_128461_(TAG_DETECTED_STRUCTURE);
            if (rawString.isEmpty()) {
                this.detectedStructures = Object2BooleanMaps.emptyMap();
            } else {
                List<ObjectBooleanPair> structureList = Arrays.stream(rawString.split(",")).map(part -> {
                    if (part.contains("|")) {
                        String[] components = part.split("\\|", 2);
                        return ObjectBooleanPair.of((Object)new ResourceLocation(components[0]), (boolean)Boolean.parseBoolean(components[1]));
                    }
                    return ObjectBooleanPair.of((Object)new ResourceLocation(part), (boolean)false);
                }).toList();
                Object2BooleanArrayMap map = new Object2BooleanArrayMap(structureList.size());
                structureList.forEach(entry -> map.put((Object)((ResourceLocation)entry.key()), entry.valueBoolean()));
                this.detectedStructures = map;
            }
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        if (this.lootTableOverride != null) {
            cmp.m_128359_(TAG_LOOT_TABLE, this.lootTableOverride.toString());
        }
        if (this.configOverride != null) {
            cmp.m_128359_(TAG_CONFIG_OVERRIDE, this.configOverride.toString());
        }
        if (this.attuneDisplayOverride != null) {
            cmp.m_128359_(TAG_ATTUNE_DISPLAY_OVERRIDE, this.attuneDisplayOverride);
        }
        if (this.detectedStructures != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean first = true;
            for (Object2BooleanMap.Entry entry : this.detectedStructures.object2BooleanEntrySet()) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(entry.getKey()).append('|').append(entry.getBooleanValue());
            }
            cmp.m_128359_(TAG_DETECTED_STRUCTURE, stringBuilder.toString());
        }
    }

    public static void dropLooniumItems(LivingEntity living, Consumer<ItemStack> consumer) {
        LooniumComponent comp = XplatAbstractions.INSTANCE.looniumComponent(living);
        if (comp != null && comp.isOverrideDrop()) {
            consumer.accept(comp.getDrop());
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<LooniumBlockEntity> {
        public WandHud(LooniumBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            String lootType;
            String structureName = "";
            if (((LooniumBlockEntity)this.flower).attuneDisplayOverride != null) {
                lootType = ((LooniumBlockEntity)this.flower).attuneDisplayOverride;
            } else if (((LooniumBlockEntity)this.flower).lootTableOverride != null) {
                lootType = "attuned";
            } else if (((LooniumBlockEntity)this.flower).detectedStructures == null || ((LooniumBlockEntity)this.flower).detectedStructures.isEmpty()) {
                lootType = "not_attuned";
            } else if (((LooniumBlockEntity)this.flower).detectedStructures.size() == 1) {
                lootType = "attuned_one";
                structureName = ((LooniumBlockEntity)this.flower).detectedStructures.keySet().stream().findFirst().map(rl -> I18n.m_118938_((String)("structure." + rl.m_135827_() + "." + rl.m_135815_().replace("/", ".")), (Object[])new Object[0])).orElseGet(() -> "");
            } else {
                lootType = "attuned_many";
            }
            String lootTypeMessage = I18n.m_118938_((String)("botaniamisc.loonium." + lootType), (Object[])new Object[]{structureName});
            int lootTypeWidth = mc.f_91062_.m_92895_(lootTypeMessage);
            int lootTypeTextStart = (mc.m_91268_().m_85445_() - lootTypeWidth) / 2;
            int halfMinWidth = (lootTypeWidth + 4) / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.m_280488_(mc.f_91062_, lootTypeMessage, lootTypeTextStart, centerY + 30, ((LooniumBlockEntity)this.flower).getColor());
        }
    }
}

