/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.AstrolabeItem;

public final class AstrolabePreviewHandler {
    public static void onWorldRenderLast(PoseStack ms, RenderBuffers buffers, Level level) {
        MultiBufferSource.BufferSource bufferSource = buffers.m_110104_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderHelper.ASTROLABE_PREVIEW);
        for (Player player : level.m_6907_()) {
            Block block;
            ItemStack currentStack = player.m_21205_();
            InteractionHand hand = InteractionHand.MAIN_HAND;
            if (currentStack.m_41619_() || !(currentStack.m_41720_() instanceof AstrolabeItem)) {
                currentStack = player.m_21206_();
                hand = InteractionHand.OFF_HAND;
            }
            if (currentStack.m_41619_() || !(currentStack.m_41720_() instanceof AstrolabeItem) || (block = AstrolabeItem.getBlock(currentStack, (HolderGetter<Block>)level.m_246945_(Registries.f_256747_))) == Blocks.f_50016_) continue;
            AstrolabePreviewHandler.renderPlayerLook(ms, buffer, player, currentStack, hand);
        }
        bufferSource.m_109912_(RenderHelper.ASTROLABE_PREVIEW);
    }

    private static void renderPlayerLook(PoseStack ms, VertexConsumer buffer, Player player, ItemStack stack, InteractionHand hand) {
        Block blockToPlace = AstrolabeItem.getBlock(stack, (HolderGetter<Block>)player.m_9236_().m_246945_(Registries.f_256747_));
        int size = AstrolabeItem.getSize(stack);
        BlockPlaceContext ctx = AstrolabeItem.getBlockPlaceContext(player, hand, blockToPlace);
        List<BlockPos> placePositions = AstrolabeItem.getPlacePositions(ctx, size);
        if (ctx != null && AstrolabeItem.hasBlocks(stack, player, placePositions.size(), blockToPlace)) {
            for (BlockPos pos : placePositions) {
                BlockPlaceContext placeContext = AstrolabePreviewHandler.getPlaceContext(player, ctx, pos);
                BlockState state = blockToPlace.m_5573_(placeContext);
                if (state == null || !placeContext.m_7059_() || !state.m_60710_((LevelReader)player.m_9236_(), pos)) continue;
                AstrolabePreviewHandler.renderBlockAt(ms, buffer, state, pos);
            }
        }
    }

    @NotNull
    private static BlockPlaceContext getPlaceContext(Player player, BlockPlaceContext ctx, BlockPos pos) {
        Vec3 newHitVec = new Vec3((double)pos.m_123341_() + Mth.m_14185_((double)ctx.m_43720_().m_7096_()), (double)pos.m_123342_() + Mth.m_14185_((double)ctx.m_43720_().m_7098_()), (double)pos.m_123343_() + Mth.m_14185_((double)ctx.m_43720_().m_7094_()));
        BlockHitResult newHit = new BlockHitResult(newHitVec, ctx.m_43719_(), pos, false);
        return new BlockPlaceContext(player, ctx.m_43724_(), ctx.m_43722_(), newHit);
    }

    private static void renderBlockAt(PoseStack ms, VertexConsumer buffer, BlockState state, BlockPos pos) {
        double renderPosX = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_().m_7096_();
        double renderPosY = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_().m_7098_();
        double renderPosZ = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_().m_7094_();
        ms.m_85836_();
        ms.m_85837_(-renderPosX, -renderPosY, -renderPosZ);
        BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
        ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        BakedModel model = brd.m_110910_(state);
        int color = Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        brd.m_110937_().m_111067_(ms.m_85850_(), buffer, state, model, r, g, b, 0xF000F0, OverlayTexture.f_118083_);
        ms.m_85849_();
    }
}

