/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.event.timed.RewindEvent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketClientRewindEffect {
    public int duration;
    public int hitEntityID;

    public PacketClientRewindEffect(FriendlyByteBuf buf) {
        this.duration = buf.readInt();
        this.hitEntityID = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.duration);
        buf.writeInt(this.hitEntityID);
    }

    public PacketClientRewindEffect(int duration, Entity hitEntity) {
        this.duration = duration;
        this.hitEntityID = hitEntity.m_19879_();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ArsNouveau.proxy.getClientWorld();
            Entity hitEntity = world.m_6815_(this.hitEntityID);
            if (hitEntity != null) {
                EventQueue.getClientQueue().addEvent(new RewindEvent(hitEntity, hitEntity.f_19853_.m_46467_(), this.duration));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

