/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.common.network;

import com.teamabnormals.personality.common.network.handler.ClientNetHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public final class MessageS2CSyncCrawl {
    private final UUID uuid;
    private final boolean crawl;

    public MessageS2CSyncCrawl(UUID uuid, boolean crawl) {
        this.uuid = uuid;
        this.crawl = crawl;
    }

    public static MessageS2CSyncCrawl deserialize(FriendlyByteBuf buf) {
        return new MessageS2CSyncCrawl(buf.m_130259_(), buf.readBoolean());
    }

    public static void handle(MessageS2CSyncCrawl message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> ClientNetHandler.handleCrawlSync(message, context));
            context.setPacketHandled(true);
        }
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeBoolean(this.crawl);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isCrawling() {
        return this.crawl;
    }
}

