/*
 * Decompiled with CFR 0.152.
 */
package net.paddedshaman.blazingbamboo.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.paddedshaman.blazingbamboo.block.BBBlocks;
import net.paddedshaman.blazingbamboo.item.BBItems;
import net.paddedshaman.blazingbamboo.util.BBDamageTypes;
import net.paddedshaman.blazingbamboo.util.BBTags;
import org.jetbrains.annotations.NotNull;

public class BlazingBambooSapling
extends BambooSaplingBlock {
    private static final int[][] nearbyPositions = new int[][]{{1, 1}, {-1, -1}, {-1, 1}, {1, -1}, {0, 1}, {0, -1}, {-1, 0}, {1, 0}};

    public BlazingBambooSapling(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BBTags.Blocks.BLAZING_BAMBOO_PLANTABLE_ON);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            pEntity.m_6469_(pLevel.m_269111_().m_269079_(BBDamageTypes.BLAZING_HOT), 1.0f);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (pFacing == Direction.UP && pFacingState.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get())) {
            pLevel.m_7731_(pCurrentPos, ((Block)BBBlocks.BLAZING_BAMBOO.get()).m_49966_(), 2);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)BBItems.BLAZING_BAMBOO_ITEM.get());
    }

    private boolean isRainingOnThis(ServerLevel pLevel, BlockPos pPos) {
        Biome biome = (Biome)pLevel.m_204166_(pPos).m_203334_();
        if (!biome.m_264473_()) {
            return false;
        }
        if (pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pPos).m_123342_() > pPos.m_123342_()) {
            return false;
        }
        return (double)pLevel.m_46722_(1.0f) > 0.2;
    }

    private boolean isHydrated(ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos mutablePos = pPos.m_122032_();
        for (int[] row : nearbyPositions) {
            mutablePos.m_122154_((Vec3i)pPos, row[0], 0, row[1]);
            BlockState mutableState = pLevel.m_8055_((BlockPos)mutablePos);
            BlockState mutableStateAbove = pLevel.m_8055_(mutablePos.m_7494_());
            if (mutableState.m_60713_(Blocks.f_49990_) || mutableStateAbove.m_60713_(Blocks.f_49990_)) {
                return true;
            }
            if (mutableState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)mutableState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return true;
            }
            if (!mutableStateAbove.m_61138_((Property)BlockStateProperties.f_61362_) || !((Boolean)mutableStateAbove.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isFrozen(ServerLevel pLevel, BlockPos pPos) {
        BlockState iceCheck = pLevel.m_8055_(pPos.m_7495_());
        return iceCheck.m_60713_(Blocks.f_50126_) || iceCheck.m_60713_(Blocks.f_50354_) || iceCheck.m_60713_(Blocks.f_50568_);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos baseBlockPos = pPos.m_7495_();
        if (this.isRainingOnThis(pLevel, pPos.m_7494_()) || this.isHydrated(pLevel, baseBlockPos)) {
            this.extinguishBamboo(pLevel, baseBlockPos);
        } else if (!this.isFrozen(pLevel, baseBlockPos) && pLevel.m_46859_(pPos.m_7494_()) && pRandom.m_188503_(3) == 0) {
            this.m_48972_((Level)pLevel, pPos);
        }
    }

    protected void extinguishBamboo(ServerLevel pLevel, BlockPos pPos) {
        pLevel.m_7731_(pPos.m_7494_(), ((Block)BBBlocks.DEAD_BAMBOO_SAPLING.get()).m_49966_(), 3);
    }

    protected void m_48972_(Level pLevel, BlockPos pPos) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((Block)BBBlocks.BLAZING_BAMBOO.get()).m_49966_().m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.SMALL), 3);
    }
}

