/*
 * Decompiled with CFR 0.152.
 */
package net.paddedshaman.blazingbamboo.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.paddedshaman.blazingbamboo.block.BBBlocks;
import net.paddedshaman.blazingbamboo.util.BBDamageTypes;
import net.paddedshaman.blazingbamboo.util.BBTags;
import org.jetbrains.annotations.Nullable;

public class BlazingBambooBlock
extends BambooStalkBlock {
    private static final int MAX_HEIGHT = 13;
    private static final int HEIGHT_VARIANCE = 5;
    private static final int[][] nearbyPositions = new int[][]{{1, 1}, {-1, -1}, {-1, 1}, {1, -1}, {0, 1}, {0, -1}, {-1, 0}, {1, 0}};

    public BlazingBambooBlock(BlockBehaviour.Properties p_48874_) {
        super(p_48874_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        if (!fluidstate.m_76178_()) {
            return null;
        }
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_());
        if (blockstate.m_204336_(BBTags.Blocks.BLAZING_BAMBOO_PLANTABLE_ON)) {
            if (blockstate.m_60713_((Block)BBBlocks.BLAZING_BAMBOO_SAPLING.get())) {
                return (BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(0));
            }
            if (blockstate.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get())) {
                int i = (Integer)blockstate.m_61143_((Property)f_260603_) > 0 ? 1 : 0;
                return (BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(i));
            }
            BlockState blockstate1 = pContext.m_43725_().m_8055_(pContext.m_8083_().m_7494_());
            return blockstate1.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) ? (BlockState)this.m_49966_().m_61124_((Property)f_260603_, blockstate1.m_61143_((Property)f_260603_)) : ((Block)BBBlocks.BLAZING_BAMBOO_SAPLING.get()).m_49966_();
        }
        return null;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BBTags.Blocks.BLAZING_BAMBOO_PLANTABLE_ON) || pLevel.m_8055_(pPos.m_7495_()).m_60713_((Block)BBBlocks.DEAD_BAMBOO.get());
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            pEntity.m_6469_(pLevel.m_269111_().m_269079_(BBDamageTypes.BLAZING_HOT), 1.0f);
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            pEntity.m_6469_(pLevel.m_269111_().m_269079_(BBDamageTypes.BLAZING_HOT), 1.0f);
        }
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
        if (pDirection == Direction.UP && pNeighborState.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) && (Integer)pNeighborState.m_61143_((Property)f_260603_) > (Integer)pState.m_61143_((Property)f_260603_)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)f_260603_), 2);
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    private boolean isRainingOnThis(ServerLevel pLevel, BlockPos pPos) {
        Biome biome = (Biome)pLevel.m_204166_(pPos).m_203334_();
        if (!biome.m_264473_()) {
            return false;
        }
        if (pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pPos).m_123342_() > pPos.m_123342_()) {
            return false;
        }
        return (double)pLevel.m_46722_(1.0f) > 0.2;
    }

    private boolean isHydrated(ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos mutablePos = pPos.m_122032_();
        for (int[] row : nearbyPositions) {
            mutablePos.m_122154_((Vec3i)pPos, row[0], 0, row[1]);
            BlockState mutableState = pLevel.m_8055_((BlockPos)mutablePos);
            BlockState mutableStateAbove = pLevel.m_8055_(mutablePos.m_7494_());
            if (mutableStateAbove.m_60713_(Blocks.f_49990_) || mutableState.m_60713_(Blocks.f_49990_)) {
                return true;
            }
            if (mutableStateAbove.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)mutableStateAbove.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return true;
            }
            if (!mutableState.m_61138_((Property)BlockStateProperties.f_61362_) || !((Boolean)mutableState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isFrozen(ServerLevel pLevel, BlockPos pPos) {
        BlockState iceCheck = pLevel.m_8055_(pPos.m_7495_());
        return iceCheck.m_60713_(Blocks.f_50126_) || iceCheck.m_60713_(Blocks.f_50354_) || iceCheck.m_60713_(Blocks.f_50568_);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = this.m_261132_((BlockGetter)pLevel, pPos) + 1;
        int j = this.m_261076_((BlockGetter)pLevel, pPos) + 1;
        BlockPos baseBlockPos = pPos.m_6625_(i);
        BlockPos headBlockPos = pPos.m_6630_(j);
        if (this.isRainingOnThis(pLevel, headBlockPos) || this.isHydrated(pLevel, baseBlockPos)) {
            this.extinguishBamboo((Level)pLevel, baseBlockPos);
        } else if (i < 13 && !this.isFrozen(pLevel, baseBlockPos) && (Integer)pState.m_61143_((Property)f_260694_) == 0 && pLevel.m_46859_(pPos.m_7494_()) && pRandom.m_188503_(3) == 0) {
            this.m_261305_(pState, (Level)pLevel, pPos, pRandom, i);
        }
    }

    protected void extinguishBamboo(Level pLevel, BlockPos baseBlockPos) {
        BlockState deadStalk = ((Block)BBBlocks.DEAD_BAMBOO.get()).m_49966_();
        int height = this.m_261076_((BlockGetter)pLevel, baseBlockPos);
        for (int i = 0; i < height; ++i) {
            BlockPos currentPos = baseBlockPos.m_6630_(i + 1);
            BlockState currentState = pLevel.m_8055_(currentPos);
            BambooLeaves deadLeaves = BambooLeaves.NONE;
            int age = (Integer)currentState.m_61143_((Property)f_260603_);
            if (currentState.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) && currentState.m_61143_((Property)f_260716_) == BambooLeaves.LARGE) {
                deadLeaves = BambooLeaves.LARGE;
            } else if (currentState.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) && currentState.m_61143_((Property)f_260716_) == BambooLeaves.SMALL) {
                deadLeaves = BambooLeaves.SMALL;
            }
            pLevel.m_7731_(currentPos, (BlockState)((BlockState)((BlockState)deadStalk.m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(age))).m_61124_((Property)f_260716_, (Comparable)deadLeaves)).m_61124_((Property)f_260694_, (Comparable)Integer.valueOf(1)), 3);
        }
    }

    protected void m_261305_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom, int pAge) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        BlockPos blockpos = pPos.m_6625_(2);
        BlockState blockstate1 = pLevel.m_8055_(blockpos);
        BambooLeaves bambooleaves = BambooLeaves.NONE;
        if (pAge >= 1) {
            if (blockstate.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) && blockstate.m_61143_((Property)f_260716_) != BambooLeaves.NONE) {
                if (blockstate.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) && blockstate.m_61143_((Property)f_260716_) != BambooLeaves.NONE) {
                    bambooleaves = BambooLeaves.LARGE;
                    if (blockstate1.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get())) {
                        pLevel.m_7731_(pPos.m_7495_(), (BlockState)blockstate.m_61124_((Property)f_260716_, (Comparable)BambooLeaves.SMALL), 3);
                        pLevel.m_7731_(blockpos, (BlockState)blockstate1.m_61124_((Property)f_260716_, (Comparable)BambooLeaves.NONE), 3);
                    }
                }
            } else {
                bambooleaves = BambooLeaves.SMALL;
            }
        }
        int i = (Integer)pState.m_61143_((Property)f_260603_) != 1 && !blockstate1.m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()) ? 0 : 1;
        int j = (pAge < 7 || pRandom.m_188501_() >= 0.25f) && pAge != 12 ? 0 : 1;
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(i))).m_61124_((Property)f_260716_, (Comparable)bambooleaves)).m_61124_((Property)f_260694_, (Comparable)Integer.valueOf(j)), 3);
    }

    protected int m_261076_(BlockGetter pLevel, BlockPos pPos) {
        int i;
        for (i = 0; i < 13 && pLevel.m_8055_(pPos.m_6630_(i + 1)).m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()); ++i) {
        }
        return i;
    }

    protected int m_261132_(BlockGetter pLevel, BlockPos pPos) {
        int i;
        for (i = 0; i < 13 && pLevel.m_8055_(pPos.m_6625_(i + 1)).m_60713_((Block)BBBlocks.BLAZING_BAMBOO.get()); ++i) {
        }
        return i;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        int j;
        int i = this.m_261076_((BlockGetter)pLevel, pPos);
        return i + (j = this.m_261132_((BlockGetter)pLevel, pPos)) + 1 < 13 && (Integer)pLevel.m_8055_(pPos.m_6630_(i)).m_61143_((Property)f_260694_) != 1;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int i = this.m_261076_((BlockGetter)pLevel, pPos);
        int j = this.m_261132_((BlockGetter)pLevel, pPos);
        int k = i + j + 1;
        BlockPos blockpos = pPos.m_6630_(i);
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (k >= 13 || (Integer)blockstate.m_61143_((Property)f_260694_) == 1 || !pLevel.m_46859_(blockpos.m_7494_())) {
            return;
        }
        this.m_261305_(blockstate, (Level)pLevel, blockpos, pRandom, k);
    }
}

