/*
 * Decompiled with CFR 0.152.
 */
package net.paddedshaman.blazingbamboo.block;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.paddedshaman.blazingbamboo.block.BlazingBambooBlock;
import net.paddedshaman.blazingbamboo.block.BlazingBambooSapling;
import net.paddedshaman.blazingbamboo.block.DeadBambooBlock;
import net.paddedshaman.blazingbamboo.block.DeadBambooSapling;
import net.paddedshaman.blazingbamboo.block.custom.BBHangingSignBlock;
import net.paddedshaman.blazingbamboo.block.custom.BBRotatedPillarBlock;
import net.paddedshaman.blazingbamboo.block.custom.BBStandingSignBlock;
import net.paddedshaman.blazingbamboo.block.custom.BBWallHangingSignBlock;
import net.paddedshaman.blazingbamboo.block.custom.BBWallSignBlock;
import net.paddedshaman.blazingbamboo.block.custom.BlazingFlowerPotBlock;
import net.paddedshaman.blazingbamboo.item.BBItems;
import net.paddedshaman.blazingbamboo.util.BBWoodTypes;

public class BBBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"blazingbamboo");
    public static final RegistryObject<Block> BLAZING_BAMBOO = BLOCKS.register("blazing_bamboo", () -> new BlazingBambooBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_280606_().m_60977_().m_60966_().m_60913_(1.0f, 6.0f).m_60918_(SoundType.f_56754_).m_60953_(pLightEmission -> 8).m_60955_().m_60988_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> DEAD_BAMBOO = BLOCKS.register("dead_bamboo", () -> new DeadBambooBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_280606_().m_60966_().m_60913_(0.0f, 6.0f).m_60918_(SoundType.f_154673_).m_60955_().m_60988_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> BLAZING_BAMBOO_SAPLING = BLOCKS.register("blazing_bamboo_sapling", () -> new BlazingBambooSapling(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280606_().m_60977_().m_60966_().m_60910_().m_60913_(0.0f, 6.0f).m_60918_(SoundType.f_56755_).m_60953_(pLightEmission -> 5).m_60955_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> DEAD_BAMBOO_SAPLING = BLOCKS.register("dead_bamboo_sapling", () -> new DeadBambooSapling(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_280606_().m_60966_().m_60910_().m_60913_(0.0f, 6.0f).m_60918_(SoundType.f_56755_).m_60955_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> POTTED_BLAZING_BAMBOO = BLOCKS.register("potted_blazing_bamboo", () -> new BlazingFlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, (Supplier<? extends Block>)BLAZING_BAMBOO, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50572_).m_60913_(0.0f, 6.0f).m_60953_(pLightEmission -> 6).m_60955_()));
    public static final RegistryObject<Block> BLAZING_BAMBOO_BUNDLE = BLOCKS.register("blazing_bamboo_bundle", () -> new BBRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 6.0f).m_60953_(pLightEmission -> 10).m_60918_(SoundType.f_243772_)));
    public static final RegistryObject<Block> STRIPPED_BLAZING_BAMBOO_BUNDLE = BBBlocks.registerBlock("stripped_blazing_bamboo_bundle", () -> new BBRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_243772_)));
    public static final RegistryObject<Block> BLAZING_BAMBOO_PLANKS = BBBlocks.registerBlock("blazing_bamboo_planks", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_243772_)));
    public static final RegistryObject<Block> BLAZING_BAMBOO_SLAB = BBBlocks.registerBlock("blazing_bamboo_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get()))));
    public static final RegistryObject<Block> BLAZING_BAMBOO_STAIRS = BBBlocks.registerBlock("blazing_bamboo_stairs", () -> new StairBlock(() -> ((Block)BLAZING_BAMBOO_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get()))));
    public static final RegistryObject<Block> BLAZING_BAMBOO_MOSAIC = BBBlocks.registerBlock("blazing_bamboo_mosaic", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get()))));
    public static final RegistryObject<Block> BLAZING_BAMBOO_MOSAIC_SLAB = BBBlocks.registerBlock("blazing_bamboo_mosaic_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get()))));
    public static final RegistryObject<Block> BLAZING_BAMBOO_MOSAIC_STAIRS = BBBlocks.registerBlock("blazing_bamboo_mosaic_stairs", () -> new StairBlock(() -> ((Block)BLAZING_BAMBOO_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get()))));
    public static final RegistryObject<Block> BLAZING_BAMBOO_BUTTON = BBBlocks.registerBlock("blazing_bamboo_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244625_).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_243772_).m_60910_(), BlockSetType.f_271088_, 30, true));
    public static final RegistryObject<Block> BLAZING_BAMBOO_PRESSURE_PLATE = BBBlocks.registerBlock("blazing_bamboo_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_243772_).m_60910_().m_60913_(0.5f, 6.0f).m_278166_(PushReaction.DESTROY), BlockSetType.f_271088_));
    public static final RegistryObject<Block> BLAZING_BAMBOO_FENCE = BBBlocks.registerBlock("blazing_bamboo_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get())).m_280606_()));
    public static final RegistryObject<Block> BLAZING_BAMBOO_FENCE_GATE = BBBlocks.registerBlock("blazing_bamboo_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLAZING_BAMBOO_PLANKS.get())), SoundEvents.f_244336_, SoundEvents.f_243721_));
    public static final RegistryObject<Block> BLAZING_BAMBOO_DOOR = BBBlocks.registerBlock("blazing_bamboo_door", () -> new DoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BASS).m_60913_(3.0f, 6.0f).m_60955_().m_278166_(PushReaction.DESTROY), BlockSetType.f_271088_));
    public static final RegistryObject<Block> BLAZING_BAMBOO_TRAPDOOR = BBBlocks.registerBlock("blazing_bamboo_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50663_).m_60918_(SoundType.f_243772_).m_60913_(3.0f, 6.0f), BlockSetType.f_271088_));
    public static final RegistryObject<Block> BLAZING_BAMBOO_SIGN = BLOCKS.register("blazing_bamboo_sign", () -> new BBStandingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60913_(1.0f, 6.0f), BBWoodTypes.BLAZING_BAMBOO));
    public static final RegistryObject<Block> BLAZING_BAMBOO_WALL_SIGN = BLOCKS.register("blazing_bamboo_wall_sign", () -> new BBWallSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60913_(1.0f, 6.0f), BBWoodTypes.BLAZING_BAMBOO));
    public static final RegistryObject<Block> BLAZING_BAMBOO_HANGING_SIGN = BLOCKS.register("blazing_bamboo_hanging_sign", () -> new BBHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60913_(1.0f, 6.0f), BBWoodTypes.BLAZING_BAMBOO));
    public static final RegistryObject<Block> BLAZING_BAMBOO_WALL_HANGING_SIGN = BLOCKS.register("blazing_bamboo_wall_hanging_sign", () -> new BBWallHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60913_(1.0f, 6.0f), BBWoodTypes.BLAZING_BAMBOO));
    public static final RegistryObject<Block> BLAZING_STONE = BBBlocks.registerBlock("blazing_stone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> BLAZING_STONE_SLAB = BBBlocks.registerBlock("blazing_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50404_).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> BLAZING_STONE_STAIRS = BBBlocks.registerBlock("blazing_stone_stairs", () -> new StairBlock(() -> ((Block)BLAZING_STONE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> BLAZING_STONE_BUTTON = BBBlocks.registerBlock("blazing_stone_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50124_).m_60918_(SoundType.f_56742_).m_60910_(), BlockSetType.f_271479_, 20, false));
    public static final RegistryObject<Block> BLAZING_STONE_PRESSURE_PLATE = BBBlocks.registerBlock("blazing_stone_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60918_(SoundType.f_56742_).m_60910_(), BlockSetType.f_271479_));
    public static final RegistryObject<Block> BLAZING_BRICKS = BBBlocks.registerBlock("blazing_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<Block> BLAZING_BRICK_SLAB = BBBlocks.registerBlock("blazing_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50411_).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<Block> BLAZING_BRICK_STAIRS = BBBlocks.registerBlock("blazing_brick_stairs", () -> new StairBlock(() -> ((Block)BLAZING_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50194_).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<Block> BLAZING_BRICK_WALL = BBBlocks.registerBlock("blazing_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50609_).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<Block> BLAZING_BRICKS_CHISELED = BBBlocks.registerBlock("blazing_bricks_chiseled", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50225_).m_60918_(SoundType.f_56721_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BBBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return BBItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41486_()));
    }
}

