/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.tile_entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMetronome;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.tile_entity.TileEntities;

public class TileEntityMetronome
extends BlockEntity {
    private static final Vec3i halfRange = new Vec3i(8, 2, 8);
    private int age = 0;
    private boolean oldPoweredState = false;
    private int countDown = 0;

    public TileEntityMetronome(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntities.METRONOME.get(), blockPos, blockState);
    }

    public void m_142466_(@NotNull CompoundTag parent) {
        super.m_142466_(parent);
    }

    public static void tick(Level level, BlockPos ignoredBlockPos, BlockState ignoredBlockState, TileEntityMetronome metronome) {
        if (metronome.f_58857_ != null) {
            BlockState state = metronome.m_58900_();
            if (((Boolean)state.m_61143_((Property)BlockMetronome.POWERED)).booleanValue()) {
                int bps;
                int pause;
                if (!metronome.oldPoweredState) {
                    metronome.age = 0;
                    metronome.countDown = 0;
                }
                if (metronome.age % (pause = Math.max(40 / (bps = Math.max((Integer)state.m_61143_((Property)BlockMetronome.BPS), 1)), 1)) == 0) {
                    if (metronome.f_58857_.f_46443_) {
                        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(SoundEvents.TICK, metronome.f_58858_.m_123341_(), metronome.f_58858_.m_123342_(), metronome.f_58858_.m_123343_(), SoundSource.BLOCKS, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.1f, (byte)-1));
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)metronome.f_58858_.m_123341_() + 0.5, (double)metronome.f_58858_.m_123342_() + 1.2, (double)metronome.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    } else if (metronome.countDown == 3) {
                        List players = level.m_6443_(Player.class, new AABB(metronome.f_58858_.m_121996_(halfRange), metronome.f_58858_.m_121955_(halfRange)), player -> player.m_21205_().m_41720_() instanceof IItemInstrument && player.m_21206_().m_41720_() instanceof ItemMusicSheet && player.m_21206_().m_41782_() && player.m_21206_().m_41783_() != null && player.m_21206_().m_41783_().m_128451_("bps") == bps);
                        XercaMusic.LOGGER.info("Metronome found " + players.size() + " players");
                        for (Player player2 : players) {
                            IItemInstrument.playMusic(level, player2, false);
                        }
                    }
                    ++metronome.countDown;
                }
                metronome.oldPoweredState = true;
                ++metronome.age;
            } else {
                metronome.oldPoweredState = false;
            }
        }
    }
}

