/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.Triggers;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.MusicUpdatePacket;

public class MusicUpdatePacketHandler {
    public static void handle(MusicUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("ServerPlayer was null when MusicUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> MusicUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(MusicUpdatePacket msg, ServerPlayer pl) {
        ItemStack note = pl.m_21205_();
        if (!note.m_41619_() && note.m_41720_() == Items.MUSIC_SHEET.get()) {
            CompoundTag comp = note.m_41784_();
            MusicUpdatePacket.FieldFlag flag = msg.getAvailability();
            if (flag.hasId) {
                comp.m_128362_("id", msg.getId());
            }
            if (flag.hasVersion) {
                comp.m_128405_("ver", msg.getVersion());
            }
            if (flag.hasLength) {
                comp.m_128405_("l", (int)msg.getLengthBeats());
            }
            if (flag.hasBps) {
                comp.m_128344_("bps", msg.getBps());
            }
            if (flag.hasVolume) {
                comp.m_128350_("vol", msg.getVolume());
            }
            if (flag.hasPrevIns) {
                comp.m_128344_("prevIns", msg.getPrevInstrument());
            }
            if (flag.hasPrevInsLocked) {
                comp.m_128379_("piLocked", msg.getPrevInsLocked());
            }
            if (flag.hasHlInterval) {
                comp.m_128344_("hl", msg.getHighlightInterval());
            }
            if (flag.hasSigned && msg.getSigned()) {
                if (flag.hasTitle) {
                    comp.m_128359_("title", msg.getTitle().trim());
                }
                comp.m_128359_("author", pl.m_7755_().getString());
                comp.m_128405_("generation", 1);
                Triggers.BECOME_MUSICIAN.trigger(pl);
            }
            if (!comp.m_128441_("generation")) {
                comp.m_128405_("generation", 0);
            }
            if (flag.hasNotes) {
                ArrayList<NoteEvent> notes = msg.getNotes();
                UUID id = comp.m_128342_("id");
                if (notes == null && (notes = MusicManager.getFinishedNotesFromBuffer(id)) == null) {
                    return;
                }
                MusicManager.setMusicData(id, comp.m_128451_("ver"), notes, pl.f_8924_);
                if (!comp.m_128441_("bps")) {
                    comp.m_128344_("bps", (byte)8);
                }
            }
        }
    }
}

