/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercamusic.common.entity.EntityMusicSpirit;
import xerca.xercamusic.common.packets.MusicEndedPacket;

public class MusicEndedPacketHandler {
    public static void handle(MusicEndedPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when MusicEndedPacketHandler was received");
            return;
        }
        ctx.get().enqueueWork(() -> MusicEndedPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(MusicEndedPacket msg, ServerPlayer pl) {
        Entity ent = pl.m_9236_().m_6815_(msg.getPlayerId());
        if (ent instanceof EntityMusicSpirit) {
            EntityMusicSpirit spirit = (EntityMusicSpirit)ent;
            spirit.setPlaying(false);
        }
    }
}

