/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import xerca.xercamusic.common.XercaMusic;

public class MusicDataRequestPacket {
    private UUID id;
    private int version;
    private boolean messageIsValid;

    public MusicDataRequestPacket(UUID id, int version) {
        this.id = id;
        this.version = version;
    }

    public MusicDataRequestPacket() {
        this.messageIsValid = false;
    }

    public static MusicDataRequestPacket decode(FriendlyByteBuf buf) {
        MusicDataRequestPacket result = new MusicDataRequestPacket();
        try {
            result.id = buf.m_130259_();
            result.version = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading MusicDataRequestPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public static void encode(MusicDataRequestPacket pkt, FriendlyByteBuf buf) {
        buf.m_130077_(pkt.getId());
        buf.writeInt(pkt.getVersion());
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

