/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.ImportMusicPacket;
import xerca.xercamusic.common.packets.ImportMusicSendPacket;
import xerca.xercamusic.common.packets.NotesPartAckFromServerPacketHandler;
import xerca.xercamusic.common.packets.SendNotesPartToServerPacket;

public class ImportMusicPacketHandler {
    public static void handle(ImportMusicPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> ImportMusicPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(ImportMusicPacket msg) {
        block6: {
            String filename = msg.getName() + ".sheet";
            String filepath = "music_sheets/" + filename;
            try {
                CompoundTag tag = NbtIo.m_128953_((File)new File(filepath));
                try {
                    ImportMusicSendPacket pack = new ImportMusicSendPacket(tag);
                    XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack);
                }
                catch (ImportMusicSendPacket.NotesTooLargeException e) {
                    if (e.id == null) {
                        throw new IOException("Music has many notes, but no UUID!");
                    }
                    int partsCount = (int)Math.ceil((double)e.notes.size() / 5000.0);
                    tag.m_128473_("notes");
                    ImportMusicSendPacket pack = new ImportMusicSendPacket(tag);
                    NotesPartAckFromServerPacketHandler.addCallback(e.id, () -> XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack));
                    for (int i = 0; i < partsCount; ++i) {
                        SendNotesPartToServerPacket partPack = new SendNotesPartToServerPacket(e.id, partsCount, i, e.notes.subList(i * 5000, Math.min((i + 1) * 5000, e.notes.size())));
                        XercaMusic.NETWORK_HANDLER.sendToServer((Object)partPack);
                    }
                }
            }
            catch (IOException | NullPointerException | ImportMusicSendPacket.NotesTooLargeException e) {
                e.printStackTrace();
                if (Minecraft.m_91087_().f_91074_ == null) break block6;
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"xercamusic.import.fail.4", (Object[])new Object[]{filepath}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

