/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xerca.xercamusic.common.CommandExport;
import xerca.xercamusic.common.CommandImport;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.TempleLootModifier;
import xerca.xercamusic.common.Triggers;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.data.BlockTags;
import xerca.xercamusic.common.entity.Entities;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.ExportMusicPacket;
import xerca.xercamusic.common.packets.ExportMusicPacketHandler;
import xerca.xercamusic.common.packets.ImportMusicPacket;
import xerca.xercamusic.common.packets.ImportMusicPacketHandler;
import xerca.xercamusic.common.packets.ImportMusicSendPacket;
import xerca.xercamusic.common.packets.ImportMusicSendPacketHandler;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacket;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacketHandler;
import xerca.xercamusic.common.packets.MusicDataRequestPacket;
import xerca.xercamusic.common.packets.MusicDataRequestPacketHandler;
import xerca.xercamusic.common.packets.MusicDataResponsePacket;
import xerca.xercamusic.common.packets.MusicDataResponsePacketHandler;
import xerca.xercamusic.common.packets.MusicEndedPacket;
import xerca.xercamusic.common.packets.MusicEndedPacketHandler;
import xerca.xercamusic.common.packets.MusicUpdatePacket;
import xerca.xercamusic.common.packets.MusicUpdatePacketHandler;
import xerca.xercamusic.common.packets.NotesPartAckFromServerPacket;
import xerca.xercamusic.common.packets.NotesPartAckFromServerPacketHandler;
import xerca.xercamusic.common.packets.SendNotesPartToServerPacket;
import xerca.xercamusic.common.packets.SendNotesPartToServerPacketHandler;
import xerca.xercamusic.common.packets.SingleNoteClientPacket;
import xerca.xercamusic.common.packets.SingleNoteClientPacketHandler;
import xerca.xercamusic.common.packets.SingleNotePacket;
import xerca.xercamusic.common.packets.SingleNotePacketHandler;
import xerca.xercamusic.common.packets.TripleNoteClientPacket;
import xerca.xercamusic.common.packets.TripleNoteClientPacketHandler;
import xerca.xercamusic.common.tile_entity.TileEntities;

@Mod(value="xercamusic")
public class XercaMusic {
    public static final String MODID = "xercamusic";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final int MAX_NOTES_IN_PACKET = 5000;
    private static final String PROTOCOL_VERSION = Integer.toString(2);
    public static final SimpleChannel NETWORK_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("xercamusic", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"xercamusic");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> TEMPLE_VOG = GLMS.register("temple_vog", TempleLootModifier.CODEC);

    private void networkRegistry() {
        int msg_id = 0;
        NETWORK_HANDLER.registerMessage(msg_id++, MusicUpdatePacket.class, MusicUpdatePacket::encode, MusicUpdatePacket::decode, MusicUpdatePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, MusicEndedPacket.class, MusicEndedPacket::encode, MusicEndedPacket::decode, MusicEndedPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, MusicBoxUpdatePacket.class, MusicBoxUpdatePacket::encode, MusicBoxUpdatePacket::decode, MusicBoxUpdatePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, SingleNotePacket.class, SingleNotePacket::encode, SingleNotePacket::decode, SingleNotePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, SingleNoteClientPacket.class, SingleNoteClientPacket::encode, SingleNoteClientPacket::decode, SingleNoteClientPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ExportMusicPacket.class, ExportMusicPacket::encode, ExportMusicPacket::decode, ExportMusicPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ImportMusicPacket.class, ImportMusicPacket::encode, ImportMusicPacket::decode, ImportMusicPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ImportMusicSendPacket.class, ImportMusicSendPacket::encode, ImportMusicSendPacket::decode, ImportMusicSendPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, MusicDataRequestPacket.class, MusicDataRequestPacket::encode, MusicDataRequestPacket::decode, MusicDataRequestPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, MusicDataResponsePacket.class, MusicDataResponsePacket::encode, MusicDataResponsePacket::decode, MusicDataResponsePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, TripleNoteClientPacket.class, TripleNoteClientPacket::encode, TripleNoteClientPacket::decode, TripleNoteClientPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, SendNotesPartToServerPacket.class, SendNotesPartToServerPacket::encode, SendNotesPartToServerPacket::decode, SendNotesPartToServerPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, NotesPartAckFromServerPacket.class, NotesPartAckFromServerPacket::encode, NotesPartAckFromServerPacket::decode, NotesPartAckFromServerPacketHandler::handle);
    }

    public XercaMusic() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Blocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Items.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Items.TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Items.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Entities.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TileEntities.BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        GLMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.networkRegistry();
            this.registerTriggers();
            Items.setup();
            SoundEvents.setup();
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"xercamod", (String)"send_note", () -> new ResourceLocation(MODID, "music_sheet"));
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.debug("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    private void registerTriggers() {
        for (int i = 0; i < Triggers.TRIGGER_ARRAY.length; ++i) {
            CriteriaTriggers.m_10595_((CriterionTrigger)Triggers.TRIGGER_ARRAY[i]);
        }
    }

    public static <T> T Null() {
        return null;
    }

    @Mod.EventBusSubscriber(modid="xercamusic")
    public static class ForgeEventHandler {
        @SubscribeEvent
        public static void onRegisterCommandEvent(RegisterCommandsEvent event) {
            CommandDispatcher commandDispatcher = event.getDispatcher();
            CommandImport.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
            CommandExport.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
        }
    }

    @Mod.EventBusSubscriber(modid="xercamusic", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerDataEvent(GatherDataEvent event) {
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)new BlockTags(event.getGenerator().getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
        }
    }
}

