/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.INBTSerializable;

public class NoteEvent
implements INBTSerializable<CompoundTag> {
    public byte note;
    public short time;
    public byte volume;
    public byte length;

    public NoteEvent(byte note, short time, byte volume, byte length) {
        this.note = note;
        this.time = time;
        this.volume = volume;
        this.length = length;
    }

    public NoteEvent() {
    }

    public short endTime() {
        return (short)(this.time + this.length - 1);
    }

    public short startTime() {
        return this.time;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("n", this.note);
        tag.m_128376_("d", this.time);
        tag.m_128344_("v", this.volume);
        tag.m_128344_("l", this.length);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.note = tag.m_128445_("n");
        this.time = tag.m_128448_("d");
        this.volume = tag.m_128445_("v");
        this.length = tag.m_128445_("l");
    }

    public static NoteEvent fromNBT(CompoundTag tag) {
        NoteEvent noteEvent = new NoteEvent();
        noteEvent.deserializeNBT(tag);
        return noteEvent;
    }

    public void encodeToBuffer(FriendlyByteBuf buf) {
        buf.writeByte((int)this.note);
        buf.writeShort((int)this.time);
        buf.writeByte((int)this.volume);
        buf.writeByte((int)this.length);
    }

    public void decodeFromBuffer(FriendlyByteBuf buf) {
        this.note = buf.readByte();
        this.time = buf.readShort();
        this.volume = buf.readByte();
        this.length = buf.readByte();
    }

    public static NoteEvent fromBuffer(FriendlyByteBuf buf) {
        NoteEvent noteEvent = new NoteEvent();
        noteEvent.decodeFromBuffer(buf);
        return noteEvent;
    }

    public static void fillArrayFromNBT(ArrayList<NoteEvent> noteEvents, CompoundTag tag) {
        ListTag notesTag = tag.m_128437_("notes", 10);
        for (int i = 0; i < notesTag.size(); ++i) {
            noteEvents.add(NoteEvent.fromNBT(notesTag.m_128728_(i)));
        }
    }

    public static void fillNBTFromArray(ArrayList<NoteEvent> noteEvents, CompoundTag tag) {
        ListTag noteList = new ListTag();
        for (NoteEvent event : noteEvents) {
            noteList.add((Object)event.serializeNBT());
        }
        tag.m_128365_("notes", (Tag)noteList);
    }

    public float floatVolume() {
        return (float)this.volume / 127.0f;
    }

    public NoteEvent clone() {
        return new NoteEvent(this.note, this.time, this.volume, this.length);
    }
}

