/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.ImportMusicPacket;
import xerca.xercamusic.common.packets.MusicDataResponsePacket;

public class CommandImport {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"musicimport").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandImport.musicImport((CommandSourceStack)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int musicImport(CommandSourceStack stack, String name) {
        XercaMusic.LOGGER.debug("Music import called. name: " + name);
        ImportMusicPacket pack = new ImportMusicPacket(name);
        try {
            ServerPlayer player = stack.m_81375_();
            XercaMusic.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)pack);
        }
        catch (CommandSyntaxException e) {
            XercaMusic.LOGGER.debug("Command executor is not a player");
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static void doImport(CompoundTag tag, ArrayList<NoteEvent> notes, ServerPlayer player) {
        if (tag.m_128425_("author", 8) && !tag.m_128425_("title", 8) || !tag.m_128425_("author", 8) && tag.m_128425_("title", 8)) {
            player.m_213846_((Component)Component.m_237115_((String)"xercamusic.import.fail.5").m_130940_(ChatFormatting.RED));
            XercaMusic.LOGGER.warn("Broken paint file");
            return;
        }
        if (tag.m_128425_("title", 8) && tag.m_128461_("title").length() > 16) {
            tag.m_128359_("title", tag.m_128461_("title").substring(0, 16));
        }
        if (tag.m_128425_("author", 8) && tag.m_128461_("author").length() > 16) {
            tag.m_128359_("author", tag.m_128461_("author").substring(0, 16));
        }
        if (!tag.m_128425_("ver", 3)) {
            tag.m_128405_("ver", 1);
        }
        if (tag.m_128451_("generation") > 0) {
            tag.m_128405_("generation", tag.m_128451_("generation") + 1);
        }
        if (tag.m_128441_("id") && tag.m_128441_("ver")) {
            id = tag.m_128342_("id");
            int ver = tag.m_128451_("ver");
            if (notes == null && (notes = MusicManager.getFinishedNotesFromBuffer(id)) == null) {
                return;
            }
            MusicManager.setMusicData(id, ver, notes, player.f_8924_);
            MusicDataResponsePacket packet = new MusicDataResponsePacket(id, ver, notes);
            XercaMusic.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            tag.m_128473_("notes");
        } else if (tag.m_128441_("music")) {
            XercaMusic.LOGGER.info("Old music file version");
            notes = ItemMusicSheet.convertFromOld(tag, player.f_8924_);
            id = tag.m_128342_("id");
            int ver = tag.m_128451_("ver");
            MusicDataResponsePacket packet = new MusicDataResponsePacket(id, ver, notes);
            XercaMusic.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            tag.m_128473_("notes");
        } else {
            XercaMusic.LOGGER.warn("Broken music file");
            return;
        }
        if (player.m_7500_()) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.MUSIC_SHEET.get());
            itemStack.m_41751_(tag);
            player.m_36356_(itemStack);
        } else {
            ItemStack mainHandStack = player.m_21205_();
            if (!(mainHandStack.m_41720_() instanceof ItemMusicSheet) || mainHandStack.m_41782_() && mainHandStack.m_41783_() != null && !mainHandStack.m_41783_().m_128456_()) {
                player.m_213846_((Component)Component.m_237115_((String)"xercamusic.import.fail.1").m_130940_(ChatFormatting.RED));
                return;
            }
            mainHandStack.m_41751_(tag);
        }
        player.m_213846_((Component)Component.m_237115_((String)"xercamusic.import.success").m_130940_(ChatFormatting.GREEN));
    }
}

