/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.packets.ExportMusicPacket;

public class CommandExport {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"musicexport").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.musicExport((CommandSourceStack)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int musicExport(CommandSourceStack stack, String name) {
        XercaMusic.LOGGER.debug("Music export called. name: " + name);
        if (stack.m_81373_() == null) {
            XercaMusic.LOGGER.error("Command entity is not found");
            return 0;
        }
        Entity commander = stack.m_81373_();
        if (!(commander instanceof ServerPlayer)) {
            XercaMusic.LOGGER.error("Command entity is not a player");
            return 0;
        }
        ServerPlayer player = (ServerPlayer)commander;
        ExportMusicPacket pack = new ExportMusicPacket(name);
        XercaMusic.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)pack);
        return 1;
    }

    public static boolean doExport(Player player, String name) {
        String dir = "music_sheets";
        String filename = name + ".sheet";
        String filepath = dir + "/" + filename;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (ItemStack s : player.m_6167_()) {
            if (!(s.m_41720_() instanceof ItemMusicSheet) || !s.m_41782_() || s.m_41783_() == null) continue;
            CompoundTag tag = s.m_41783_().m_6426_();
            if (tag.m_128441_("id") && tag.m_128441_("ver")) {
                UUID id = tag.m_128342_("id");
                int ver = tag.m_128451_("ver");
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        NoteEvent.fillNBTFromArray(data.notes, tag);
                        try {
                            NbtIo.m_128955_((CompoundTag)tag, (File)new File(filepath));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }
}

