/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.renderer.block.BlueprintChestBlockEntityRenderer;
import com.teamabnormals.blueprint.core.api.IChestBlock;
import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.core.other.WoodworksModelLayers;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;

public class DrawerBlockEntityRenderer<T extends BlockEntity>
extends BlueprintChestBlockEntityRenderer<T> {
    public static Block itemBlock = null;
    private final ModelPart leftDoor;
    private final ModelPart leftBack;
    private final ModelPart tallLeftDoor;
    private final ModelPart tallLeftBack;
    private final ModelPart rightDoor;
    private final ModelPart rightBack;
    private final ModelPart tallRightDoor;
    private final ModelPart tallRightBack;

    public DrawerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        ModelPart left = context.m_173582_(WoodworksModelLayers.BAMBOO_CLOSET_LEFT);
        this.leftBack = left.m_171324_("back");
        this.leftDoor = left.m_171324_("door");
        ModelPart tallLeft = context.m_173582_(WoodworksModelLayers.BAMBOO_CLOSET_TALL_LEFT);
        this.tallLeftBack = tallLeft.m_171324_("back");
        this.tallLeftDoor = tallLeft.m_171324_("door");
        ModelPart right = context.m_173582_(WoodworksModelLayers.BAMBOO_CLOSET_RIGHT);
        this.rightBack = right.m_171324_("back");
        this.rightDoor = right.m_171324_("door");
        ModelPart tallRight = context.m_173582_(WoodworksModelLayers.BAMBOO_CLOSET_TALL_RIGHT);
        this.tallRightBack = tallRight.m_171324_("back");
        this.tallRightDoor = tallRight.m_171324_("door");
    }

    public static LayerDefinition createBodyLayer(boolean tall, boolean mirror) {
        float height = tall ? 16.0f : 14.0f;
        float pivot = mirror ? 15.0f : 1.0f;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition back = partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(1.0f, 0.0f, 1.0f, 14.0f, height, 11.0f, mirror), PartPose.f_171404_);
        PartDefinition door = partdefinition.m_171599_("door", CubeListBuilder.m_171558_().m_171514_(0, tall ? 27 : 25).m_171506_(-pivot + 1.0f, 0.0f, 0.0f, 14.0f, height, 4.0f, mirror), PartPose.m_171419_((float)pivot, (float)0.0f, (float)11.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level level = tileEntityIn.m_58904_();
        boolean flag = level != null;
        BlockState state = flag ? tileEntityIn.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = state.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)state.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = state.m_60734_();
        if (block instanceof AbstractChestBlock) {
            boolean right;
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            poseStack.m_85836_();
            Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
            float f = facing.m_122435_();
            boolean bl = right = state.m_61138_(ClosetBlock.HINGE) && state.m_61143_(ClosetBlock.HINGE) == DoorHingeSide.RIGHT;
            if (flag && ClosetBlock.shouldTranslateCloset(state, (BlockGetter)level, tileEntityIn.m_58899_())) {
                poseStack.m_85837_((double)facing.m_122436_().m_123343_() * 0.0625 * (right ? -1.0 : 1.0), 0.0, (double)(-facing.m_122436_().m_123341_()) * 0.0625 * (right ? -1.0 : 1.0));
            }
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = flag ? abstractchestblock.m_5641_(state, level, tileEntityIn.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)tileEntityIn)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            if (right) {
                f1 *= -1.0f;
            }
            int i = ((Int2IntFunction)icallbackwrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            VertexConsumer ivertexbuilder = this.getChestMaterial(tileEntityIn, chesttype).m_119194_(bufferIn, RenderType::m_110452_);
            if (flag1 && chesttype == ChestType.RIGHT) {
                this.render(poseStack, ivertexbuilder, right ? this.tallRightDoor : this.tallLeftDoor, right ? this.tallRightBack : this.tallLeftBack, f1, i, combinedOverlayIn);
            } else {
                this.render(poseStack, ivertexbuilder, right ? this.rightDoor : this.leftDoor, right ? this.rightBack : this.leftBack, f1, i, combinedOverlayIn);
            }
            poseStack.m_85849_();
        }
    }

    public Material getChestMaterial(T t, ChestType type) {
        Block inventoryBlock = itemBlock;
        if (inventoryBlock == null) {
            inventoryBlock = t.m_58900_().m_60734_();
        }
        BlueprintChestMaterials.ChestMaterials chestMaterials = BlueprintChestMaterials.getMaterials((String)((IChestBlock)inventoryBlock).getChestMaterialsName());
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChestType.SINGLE -> {
                if (chestMaterials != null) {
                    yield chestMaterials.singleMaterial();
                }
                yield Sheets.f_110751_;
            }
            case ChestType.LEFT -> {
                if (chestMaterials != null) {
                    yield chestMaterials.leftMaterial();
                }
                yield Sheets.f_110752_;
            }
            case ChestType.RIGHT -> chestMaterials != null ? chestMaterials.rightMaterial() : Sheets.f_110753_;
        };
    }

    public void render(PoseStack matrixStack, VertexConsumer builder, ModelPart closetDoor, ModelPart closetBack, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        closetDoor.f_104204_ = -(lidAngle * 1.701696f);
        closetDoor.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        closetBack.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
    }
}

