/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.forge.mixin.realistic_horse_genetics;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.horse.HitchableHorse;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.HorseInventoryMenu;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sekelsta.horse_colors.client.HorseGui;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;

@Mixin(value={HorseGui.class})
public abstract class HorseGUIMixin
extends HorseInventoryScreen {
    @Shadow(remap=false)
    @Final
    private AbstractHorseGenetic horseGenetic;
    @Unique
    private static final ResourceLocation LEAD_SLOT_TEXTURE = Horseman.resource("textures/gui/lead_slot.png");

    public HorseGUIMixin(HorseInventoryMenu menu, Inventory playerInventory, AbstractHorse horse) {
        super(menu, playerInventory, horse);
    }

    @Inject(method={"renderBg"}, at={@At(value="RETURN")})
    private void onRenderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY, CallbackInfo ci) {
        AbstractHorseGenetic abstractHorseGenetic = this.horseGenetic;
        if (!(abstractHorseGenetic instanceof HitchableHorse)) {
            return;
        }
        HitchableHorse horse = (HitchableHorse)abstractHorseGenetic;
        if (HitchableHorse.shouldHaveLeadSlot(horse)) {
            int leftPos = (this.f_96543_ - this.f_97726_) / 2;
            int topPos = (this.f_96544_ - this.f_97727_) / 2;
            guiGraphics.m_280218_(LEAD_SLOT_TEXTURE, leftPos + 7, topPos + 53, 0, 0, 18, 18);
        }
    }
}

