/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.gas;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.item.cosmetic.StarBalloon;
import alexthw.starbunclemania.starbuncle.StarHelper;
import alexthw.starbunclemania.starbuncle.gas.GasExtractGoal;
import alexthw.starbunclemania.starbuncle.gas.GasStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyGasBehavior
extends StarbyListBehavior {
    public static final Capability<IGasHandler> GAS_HANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGasHandler>(){});
    private GasStack gasStack = GasStack.EMPTY;
    public static final ResourceLocation TRANSPORT_ID = new ResourceLocation("starbunclemania", "starby_gas_transport");

    public StarbyGasBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.m_128441_("gasName")) {
            this.gasStack = GasStack.readFromNBT((CompoundTag)tag);
        }
        this.goals.add(new WrappedGoal(3, (Goal)new GasStoreGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new GasExtractGoal(entity, this)));
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || this.getTankToExtract() == null && (this.getGasStack().isEmpty() || this.getTankForStorage() == null);
    }

    @NotNull
    public GasStack getGasStack() {
        return this.gasStack;
    }

    public void setGasStack(GasStack gas) {
        this.gasStack = gas;
        this.syncTag();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity be;
        super.onFinishedConnectionFirst(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && (be = this.level.m_7702_(storedPos)) != null && be.getCapability(GAS_HANDLER).isPresent()) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.gas_to"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity be;
        super.onFinishedConnectionLast(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && (be = this.level.m_7702_(storedPos)) != null && be.getCapability(GAS_HANDLER).isPresent()) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.gas_from"));
        }
    }

    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.storing_gas", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.taking_gas", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.gasStack.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)(this.getGasStack().getAmount() + " ")).m_7220_((Component)Component.m_237115_((String)this.getGasStack().getTranslationKey())));
        }
    }

    public int getRatio() {
        return (Integer)Configs.STARBALLOON_RATIO.get();
    }

    protected ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public BlockPos getTankForStorage(GasStack gasInTank) {
        if (!gasInTank.isEmpty()) {
            for (BlockPos pos : this.TO_LIST) {
                if (!this.level.m_46749_(pos) || !this.canStore(pos, gasInTank)) continue;
                return pos;
            }
        }
        return null;
    }

    public BlockPos getTankForStorage() {
        return this.getTankForStorage(this.getGasStack());
    }

    public BlockPos getTankToExtract() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.level.m_46749_(pos) || !this.canExtract(pos)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public static IGasHandler getHandlerFromCap(BlockPos pos, Level level, int sideOrdinal) {
        BlockEntity be = level.m_7702_(pos);
        Direction side = (sideOrdinal = StarHelper.checkItemFramesForSide(pos, level, sideOrdinal, be)) < 0 ? Direction.UP : Direction.values()[sideOrdinal];
        return be != null && be.getCapability(GAS_HANDLER, side).isPresent() && be.getCapability(GAS_HANDLER, side).resolve().isPresent() ? (IGasHandler)be.getCapability(GAS_HANDLER, side).resolve().get() : null;
    }

    public IGasHandler getHandlerFromCap(BlockPos pos, Direction side) {
        return StarbyGasBehavior.getHandlerFromCap(pos, this.level, side == null ? -1 : side.ordinal());
    }

    public boolean canStore(BlockPos pos, @NotNull GasStack gasStack) {
        IGasHandler gas = this.getHandlerFromCap(pos, (Direction)this.TO_DIRECTION_MAP.get(pos.hashCode()));
        if (gas != null) {
            for (int i = 0; i < gas.getTanks(); ++i) {
                if (!gas.isValid(i, (ChemicalStack)gasStack) || ((GasStack)gas.insertChemical((ChemicalStack)gasStack, Action.SIMULATE)).getAmount() > (long)((Integer)Configs.STARBALLOON_THRESHOLD.get()).intValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExtract(BlockPos pos) {
        IGasHandler gas = this.getHandlerFromCap(pos, (Direction)this.FROM_DIRECTION_MAP.get(pos.hashCode()));
        if (gas != null) {
            for (int i = 0; i < gas.getTanks(); ++i) {
                if (((GasStack)gas.getChemicalInTank(i)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (!this.getGasStack().isEmpty()) {
            this.getGasStack().write(tag);
        }
        return super.toTag(tag);
    }

    public ItemStack getStackForRender() {
        if (this.starbuncle.getCosmeticItem().m_41720_() instanceof StarBalloon) {
            this.starbuncle.getCosmeticItem().m_41784_().m_128405_("color", this.gasStack.getChemicalColorRepresentation());
        }
        return ItemStack.f_41583_;
    }
}

