/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.gas;

import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;

public class GasStoreGoal
extends GoToPosGoal<StarbyGasBehavior> {
    public GasStoreGoal(Starbuncle starbuncle, StarbyGasBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> !behavior.getGasStack().isEmpty());
    }

    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    public BlockPos getDestination() {
        return ((StarbyGasBehavior)this.behavior).getTankForStorage();
    }

    public boolean onDestinationReached() {
        this.starbuncle.getNavigation().m_26573_();
        IGasHandler gasHandler = ((StarbyGasBehavior)this.behavior).getHandlerFromCap(this.targetPos, (Direction)((StarbyGasBehavior)this.behavior).TO_DIRECTION_MAP.get(this.targetPos.hashCode()));
        int tankIndex = 0;
        if (gasHandler != null) {
            int room = (int)(gasHandler.getTankCapacity(tankIndex) - ((GasStack)gasHandler.getChemicalInTank(tankIndex)).getAmount());
            if (room <= 0) {
                this.starbuncle.setBackOff(5 + this.starbuncle.m_9236_().f_46441_.m_188503_(20));
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("no_room", this.targetPos.toString()));
                return true;
            }
            int diff = (int)Math.min((long)room, ((StarbyGasBehavior)this.behavior).getGasStack().getAmount());
            GasStack fill = new GasStack(((StarbyGasBehavior)this.behavior).getGasStack(), (long)diff);
            ((StarbyGasBehavior)this.behavior).setGasStack((GasStack)gasHandler.insertChemical((ChemicalStack)fill, Action.EXECUTE));
            this.starbuncle.m_9236_().m_5594_(null, this.targetPos, SoundEvents.f_144098_, SoundSource.NEUTRAL, 0.2f, 1.3f);
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("stored_gas", "successful at " + this.targetPos.toString() + "set gas stack to " + diff + "x " + fill.getTypeRegistryName()));
        } else {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No gas handler at " + this.targetPos.toString()));
        }
        return true;
    }
}

