/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.datagen;

import alexthw.starbunclemania.registry.ModRegistry;
import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancementBuilder;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancements;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class StarAdvancementsProvider
extends ForgeAdvancementProvider {
    public StarAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new AEAdvancements()));
    }

    public static class AEAdvancements
    extends ANAdvancements {
        static Consumer<Advancement> advancementConsumer;

        static Advancement dummy(String name) {
            return new Advancement(new ResourceLocation("ars_nouveau", name), null, null, AdvancementRewards.f_9978_, (Map)ImmutableMap.of(), null, false);
        }

        public void generate(HolderLookup.Provider registries, Consumer<Advancement> con, ExistingFileHelper existingFileHelper) {
            advancementConsumer = con;
            Advancement starbyCharm = AEAdvancements.dummy("starby_charm");
            this.saveBasicItem((ItemLike)ModRegistry.STARBUCKET.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.STARBALLON.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.STARBATTERY.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.STARTRASH.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.PROFHAT.get(), starbyCharm);
            Advancement jar = AEAdvancements.dummy("source_jar");
            Advancement fluidJar = this.saveBasicItem((ItemLike)ModRegistry.FLUID_JAR.get(), jar);
            this.saveBasicItem((ItemLike)ModRegistry.SOURCE_CONDENSER.get(), fluidJar);
            this.saveBasicItem((ItemLike)ModRegistry.FLUID_SOURCELINK.get(), fluidJar);
            Advancement wixie = AEAdvancements.dummy("wixie_charm");
            this.builder("wixie_cook").display((ItemLike)Blocks.f_50094_, FrameType.TASK, false).addCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(ModRegistry.WIXIE_1.m_7295_(), ContextAwarePredicate.f_285567_)).parent(wixie).save(con);
            this.builder("wixie_stoneworks").display((ItemLike)Blocks.f_50679_, FrameType.TASK, false).addCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(ModRegistry.WIXIE_2.m_7295_(), ContextAwarePredicate.f_285567_)).parent(wixie).save(con);
        }

        public Advancement saveBasicItem(ItemLike item, Advancement parent) {
            return this.buildBasicItem(item, ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), FrameType.TASK, parent).save(advancementConsumer);
        }

        public ANAdvancementBuilder buildBasicItem(ItemLike item, String id, FrameType frame, Advancement parent) {
            return this.builder(id).display(item, frame).requireItem(item).parent(parent);
        }

        public ANAdvancementBuilder builder(String key) {
            return ANAdvancementBuilder.builder((String)"starbunclemania", (String)key);
        }
    }
}

