/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.fluids;

import alexthw.starbunclemania.common.block.fluids.AbstractTankTile;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LiquidJarTile
extends AbstractTankTile
implements ITooltipProvider,
ITickable {
    public static int capacity = 16000;

    public LiquidJarTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUID_JAR_TILE.get(), pos, state);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public float getFluidPercentage() {
        return (float)this.getFluidAmount() / (float)capacity;
    }

    public void setFluid(FluidStack fluidFromTag) {
        this.tank.setFluid(fluidFromTag);
    }

    public void tick() {
        PotionData stored;
        PotionJarTile potionJar;
        BlockEntity be;
        if (this.f_58857_ instanceof ServerLevel && this.f_58857_.m_46467_() % 20L == 0L && !this.tank.isEmpty() && this.tank.getFluid().hasTag() && this.tank.getFluidAmount() >= 250 && this.tank.getFluid().getFluid().m_205067_(ModRegistry.POTION) && (be = this.f_58857_.m_7702_(this.m_58899_().m_7494_())) instanceof PotionJarTile && (potionJar = (PotionJarTile)be).getAmount() < potionJar.getMaxFill() && potionJar.canAccept(stored = PotionData.fromTag((CompoundTag)this.tank.getFluid().getTag()), 100)) {
            potionJar.add(stored, 100);
            this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void getTooltip(List<Component> tooltip) {
        FluidStack fluid = this.getFluid();
        LiquidJarTile.displayFluidTooltip(tooltip, fluid);
    }

    public static void displayFluidTooltip(List<Component> tooltip, FluidStack fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"starbunclemania.tooltip.fluid_jar", (Object[])new Object[]{fluid.getAmount()}).m_7220_(fluid.getDisplayName()));
    }
}

