/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import alexthw.starbunclemania.client.FluidSourceLinkRenderer;
import alexthw.starbunclemania.client.JarRenderer;
import alexthw.starbunclemania.client.ResizedStarbRender;
import alexthw.starbunclemania.client.SourceCondenserRenderer;
import alexthw.starbunclemania.registry.EidolonCompat;
import alexthw.starbunclemania.registry.FarmerDelightCompat;
import alexthw.starbunclemania.registry.ModRegistry;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="starbunclemania", bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    @SubscribeEvent
    public static void bindRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModRegistry.FLUID_SOURCELINK_TILE.get(), FluidSourceLinkRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModRegistry.SOURCE_CONDENSER_TILE.get(), SourceCondenserRenderer::new);
        event.registerEntityRenderer((EntityType)ModRegistry.STARBY_MOUNT.get(), ResizedStarbRender::new);
        if (ModList.get().isLoaded("eidolon")) {
            EidolonCompat.onRegisterRenders(event);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmerDelightCompat.onRegisterRenders(event);
        }
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent evt) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModRegistry.FLUID_JAR_TILE.get()), context -> new JarRenderer());
        evt.enqueueWork(() -> ItemProperties.register((Item)((Item)ModRegistry.DIRECTION_SCROLL.get()), (ResourceLocation)new ResourceLocation("starbunclemania", "side"), (stack, level, entity, seed) -> {
            CompoundTag tag = stack.m_41783_();
            return tag != null ? (float)tag.m_128451_("side") : -1.0f;
        }));
    }

    @SubscribeEvent
    public static void registerColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex == 0 ? stack.m_41784_().m_128451_("color") : -1, new ItemLike[]{(ItemLike)ModRegistry.STARBALLON.get()});
    }
}

