/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies;

import io.github.sirjain0.perfectplushies.CommonClass;
import io.github.sirjain0.perfectplushies.Constants;
import io.github.sirjain0.perfectplushies.config.CommonConfig;
import io.github.sirjain0.perfectplushies.datagen.ModBlockStateProvider;
import io.github.sirjain0.perfectplushies.datagen.ModItemModelProvider;
import io.github.sirjain0.perfectplushies.datagen.ModLangProvider;
import io.github.sirjain0.perfectplushies.datagen.ModLootTableProvider;
import io.github.sirjain0.perfectplushies.datagen.ModRecipeProvider;
import io.github.sirjain0.perfectplushies.datagen.ModSoundProvider;
import io.github.sirjain0.perfectplushies.datagen.ModTagProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="perfectplushies")
@Mod.EventBusSubscriber(modid="perfectplushies", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PerfectPlushies {
    public PerfectPlushies() {
        Constants.LOG.info("Hello Forge world!");
        CommonClass.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        PackOutput packOutput = event.getGenerator().getPackOutput();
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        boolean includeClient = event.includeClient();
        generator.addProvider(includeServer, (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new ModLootTableProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new ModSoundProvider(packOutput, existingFileHelper));
        generator.addProvider(includeServer, (DataProvider)new ModTagProvider.Blocks(packOutput, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(includeServer, (DataProvider)new ModTagProvider.Items(packOutput, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(includeClient, (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(includeClient, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(includeClient, (DataProvider)new ModLangProvider(packOutput));
    }
}

