/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io;

import com.enderio.api.capability.ISideConfig;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.base.common.init.EIOCapabilities;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class IOConfig
implements IIOConfig {
    private final EnumMap<Direction, IOMode> config = new EnumMap(Direction.class);
    private final EnumMap<Direction, LazyOptional<SideAccess>> sideAccessCache = new EnumMap(Direction.class);

    public IOConfig() {
        for (Direction value : Direction.values()) {
            this.config.put(value, IOMode.NONE);
        }
    }

    @Override
    public IOMode getMode(Direction side) {
        return this.config.get(this.translateSide(side));
    }

    @Override
    public void setMode(Direction side, IOMode mode) {
        Direction relSide = this.translateSide(side);
        IOMode oldMode = this.config.get(relSide);
        this.config.put(relSide, mode);
        this.onChanged(side, oldMode, mode);
    }

    @Override
    public boolean supportsMode(Direction side, IOMode state) {
        return true;
    }

    @Override
    public boolean renderOverlay() {
        return true;
    }

    private Direction translateSide(Direction side) {
        Direction south = this.getBlockFacing();
        return switch (side) {
            case Direction.NORTH -> south.m_122424_();
            case Direction.SOUTH -> south;
            case Direction.WEST -> south.m_122428_();
            case Direction.EAST -> south.m_122427_();
            default -> side;
        };
    }

    @Override
    public Capability<ISideConfig> getCapabilityType() {
        return EIOCapabilities.SIDE_CONFIG;
    }

    @Override
    public LazyOptional<ISideConfig> getCapability(@Nullable Direction side) {
        if (side == null) {
            return LazyOptional.empty();
        }
        return this.sideAccessCache.computeIfAbsent(side, dir -> LazyOptional.of(() -> new SideAccess(this, (Direction)dir))).cast();
    }

    @Override
    public void invalidateSide(@Nullable Direction side) {
        if (side == null) {
            return;
        }
        if (this.sideAccessCache.containsKey(side)) {
            this.sideAccessCache.get(side).invalidate();
            this.sideAccessCache.remove(side);
        }
    }

    @Override
    public void invalidateCaps() {
        for (LazyOptional<SideAccess> access : this.sideAccessCache.values()) {
            access.invalidate();
        }
    }

    protected void onChanged(Direction side, IOMode oldMode, IOMode newMode) {
    }

    protected Direction getBlockFacing() {
        return Direction.SOUTH;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<Direction, IOMode> entry : this.config.entrySet()) {
            nbt.m_128344_("" + entry.getKey().m_122411_(), (byte)entry.getValue().ordinal());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            if (!nbt.m_128425_(key, 1)) continue;
            try {
                int i = Integer.parseInt(key);
                if (i < 0 || i >= Direction.values().length) continue;
                Direction direction = Direction.m_122376_((int)i);
                byte ioModeIndex = nbt.m_128445_(key);
                if (ioModeIndex < 0 || ioModeIndex >= IOMode.values().length) continue;
                this.config.put(direction, IOMode.values()[ioModeIndex]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOConfig ioConfig = (IOConfig)o;
        return this.config.equals((Object)ioConfig.config);
    }

    public int hashCode() {
        int h = 0;
        for (Map.Entry<Direction, IOMode> entry : this.config.entrySet()) {
            h += entry.getKey().ordinal() ^ 31 * entry.getValue().ordinal();
        }
        return h;
    }

    private record SideAccess(IOConfig config, Direction side) implements ISideConfig
    {
        @Override
        public IOMode getMode() {
            return this.config.getMode(this.side);
        }

        @Override
        public void setMode(IOMode mode) {
            this.config.setMode(this.side, mode);
        }

        @Override
        public void cycleMode() {
            this.config.cycleMode(this.side);
        }
    }
}

