/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.screen;

import com.enderio.api.misc.IIcon;
import com.enderio.api.misc.Vector2i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public interface IEnderScreen {
    default public Screen getScreen() {
        return (Screen)this;
    }

    public static void renderIcon(GuiGraphics guiGraphics, Vector2i pos, IIcon icon) {
        if (!icon.shouldRender()) {
            return;
        }
        RenderSystem.enableBlend();
        guiGraphics.m_280411_(icon.getTextureLocation(), pos.x(), pos.y(), icon.getRenderSize().x(), icon.getRenderSize().y(), (float)icon.getTexturePosition().x(), (float)icon.getTexturePosition().y(), icon.getIconSize().x(), icon.getIconSize().y(), icon.getTextureSize().x(), icon.getTextureSize().y());
        RenderSystem.disableBlend();
    }

    default public void renderSimpleArea(GuiGraphics guiGraphics, Vector2i pos, Vector2i pos2) {
        guiGraphics.m_280509_(pos.x(), pos.y(), pos2.x(), pos2.y(), -7631989);
        guiGraphics.m_280509_(pos.x(), pos.y(), pos2.x() - 1, pos2.y() - 1, -13158601);
        guiGraphics.m_280509_(pos.x() + 1, pos.y() + 1, pos2.x(), pos2.y(), -1);
        guiGraphics.m_280509_(pos.x() + 1, pos.y() + 1, pos2.x() - 1, pos2.y() - 1, -7631989);
    }

    default public void renderIconBackground(GuiGraphics guiGraphics, Vector2i pos, IIcon icon) {
        this.renderSimpleArea(guiGraphics, pos, pos.add(icon.getRenderSize()));
    }

    default public void renderTooltipAfterEverything(GuiGraphics guiGraphics, List<Component> pText, int pMouseX, int pMouseY) {
        this.addTooltip(new LateTooltipData(guiGraphics, pText, pMouseX, pMouseY));
    }

    public void addTooltip(LateTooltipData var1);

    public static class LateTooltipData {
        private final GuiGraphics guiGraphics;
        private final List<Component> text;
        private final int mouseX;
        private final int mouseY;

        LateTooltipData(GuiGraphics guiGraphics, List<Component> text, int mouseX, int mouseY) {
            this.guiGraphics = guiGraphics;
            this.text = text;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public GuiGraphics getGuiGraphics() {
            return this.guiGraphics;
        }

        public List<Component> getText() {
            return this.text;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }
    }
}

