/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.item;

import com.enderio.api.conduit.ConduitData;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class ItemConduitData
implements ConduitData<ItemConduitData> {
    private final Map<Direction, ItemSidedData> itemSidedData = new EnumMap<Direction, ItemSidedData>(Direction.class);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Direction direction : Direction.values()) {
            @Nullable ItemSidedData sidedData = this.itemSidedData.get(direction);
            if (sidedData == null) continue;
            tag.m_128365_(direction.name(), (Tag)sidedData.toNbt());
        }
        return tag;
    }

    @Override
    public CompoundTag serializeGuiNBT() {
        CompoundTag tag = new CompoundTag();
        for (Direction direction : Direction.values()) {
            @Nullable ItemSidedData sidedData = this.itemSidedData.get(direction);
            if (sidedData == null) continue;
            tag.m_128365_(direction.name(), (Tag)sidedData.toGuiNbt());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Direction direction : Direction.values()) {
            if (!nbt.m_128441_(direction.name())) continue;
            this.itemSidedData.put(direction, ItemSidedData.fromNbt(nbt.m_128469_(direction.name())));
        }
    }

    public ItemSidedData get(Direction direction) {
        return this.itemSidedData.getOrDefault(direction, new ItemSidedData());
    }

    public ItemSidedData compute(Direction direction) {
        return this.itemSidedData.computeIfAbsent(direction, dir -> new ItemSidedData());
    }

    public int hashCode() {
        return this.itemSidedData.hashCode();
    }

    public static class ItemSidedData {
        public boolean isRoundRobin = false;
        public int rotatingIndex = 0;
        public boolean isSelfFeed = false;
        private int priority = 0;
        private static final String KEY_ROTATING_INDEX = "RotatingIndex";
        private static final String KEY_ROUND_ROBIN = "RoundRobin";
        private static final String KEY_SELF_FEED = "SelfFeed";
        private static final String KEY_PRIORITY = "Priority";

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            if (priority >= -9999 && priority <= 9999) {
                this.priority = priority;
            }
        }

        public int hashCode() {
            return Objects.hash(this.isRoundRobin, this.isSelfFeed, this.priority);
        }

        private CompoundTag toNbt() {
            CompoundTag nbt = this.toGuiNbt();
            nbt.m_128405_(KEY_ROTATING_INDEX, this.rotatingIndex);
            return nbt;
        }

        private CompoundTag toGuiNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_(KEY_ROUND_ROBIN, this.isRoundRobin);
            nbt.m_128379_(KEY_SELF_FEED, this.isSelfFeed);
            nbt.m_128405_(KEY_PRIORITY, this.priority);
            return nbt;
        }

        private static ItemSidedData fromNbt(CompoundTag nbt) {
            ItemSidedData sidedData = new ItemSidedData();
            sidedData.isRoundRobin = nbt.m_128471_(KEY_ROUND_ROBIN);
            sidedData.isSelfFeed = nbt.m_128471_(KEY_SELF_FEED);
            sidedData.priority = nbt.m_128451_(KEY_PRIORITY);
            if (nbt.m_128441_(KEY_ROTATING_INDEX)) {
                sidedData.rotatingIndex = nbt.m_128451_(KEY_ROTATING_INDEX);
            }
            return sidedData;
        }
    }
}

