/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.capability.AcceptingFluidItemHandler;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.item.tool.PoweredToggledItem;
import com.enderio.base.common.tag.EIOTags;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class LevitationStaffItem
extends PoweredToggledItem {
    public LevitationStaffItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected int getEnergyUse() {
        return (Integer)BaseConfig.COMMON.ITEMS.LEVITATION_STAFF_ENERGY_USE.get();
    }

    @Override
    protected int getMaxEnergy() {
        return (Integer)BaseConfig.COMMON.ITEMS.LEVITATION_STAFF_MAX_ENERGY.get();
    }

    @Override
    protected boolean hasCharge(ItemStack pStack) {
        return this.getTankCap(pStack).map(handler -> !handler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()).orElse(false) != false && super.hasCharge(pStack);
    }

    @Override
    protected void consumeCharge(ItemStack pStack) {
        super.consumeCharge(pStack);
        this.getTankCap(pStack).ifPresent(handler -> handler.drain(1, IFluidHandler.FluidAction.EXECUTE));
    }

    @Override
    protected void setFullCharge(ItemStack pStack) {
        super.setFullCharge(pStack);
        this.getTankCap(pStack).ifPresent(handler -> {
            if (handler instanceof AcceptingFluidItemHandler) {
                AcceptingFluidItemHandler fluidHandler = (AcceptingFluidItemHandler)((Object)handler);
                fluidHandler.setFluid(new FluidStack((Fluid)EIOFluids.VAPOR_OF_LEVITY.get(), handler.getTankCapacity(0)));
            }
        });
    }

    @Override
    protected void onTickWhenActive(Player player, ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 1));
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(ForgeCapabilities.FLUID_HANDLER_ITEM, new AcceptingFluidItemHandler(stack, 1000, EIOTags.Fluids.STAFF_OF_LEVITY_FUEL).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM));
        return super.initCapabilities(stack, nbt, provider);
    }

    private Optional<IFluidHandlerItem> getTankCap(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
    }
}

