/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.integration;

import com.enderio.api.integration.Integration;
import com.enderio.api.integration.IntegrationManager;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class IntegrationWrapper<T extends Integration> {
    private final String modid;
    @Nullable
    private final T value;

    public IntegrationWrapper(String modid, Supplier<Supplier<T>> supplier) {
        this.modid = modid;
        this.value = ModList.get().isLoaded(modid) ? (Integration)supplier.get().get() : null;
        this.ifPresent(integration -> {
            IntegrationManager.addIntegration(integration);
            integration.addEventListener(FMLJavaModLoadingContext.get().getModEventBus(), MinecraftForge.EVENT_BUS);
        });
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public T expectPresent() {
        return this.value;
    }
}

