/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.tileentity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nomadictents.NTConfig;
import nomadictents.NTSavedData;
import nomadictents.dimension.DimensionFactory;
import nomadictents.dimension.DynamicDimensionHelper;
import nomadictents.item.MalletItem;
import nomadictents.registries.NTBlockEntityRegistry;
import nomadictents.structure.TentPlacer;
import nomadictents.util.Tent;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public class TentDoorBlockEntity
extends BlockEntity {
    public static final String TENT_COPY_TOOL = "TentCopyTool";
    private static final String TENT = "tent";
    private static final String DIRECTION = "direction";
    private static final String SPAWNPOINT = "spawnpoint";
    private static final String SPAWN_ROTATION = "spawn_rot";
    private static final String SPAWN_DIMENSION = "spawn_dim";
    private static final String OWNER = "owner";
    private Tent tent = new Tent(0, TentType.YURT, TentSize.TINY);
    private Direction direction = TentPlacer.TENT_DIRECTION;
    private ResourceLocation spawnDimension = LevelStem.f_63971_.m_135782_();
    private Vec3 spawnpoint = Vec3.f_82478_;
    private float spawnRot;
    private UUID owner;

    public TentDoorBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)NTBlockEntityRegistry.TENT_BLOCK_ENTITY.get(), pos, blockState);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41782_() && heldItem.m_41783_().m_128441_(TENT_COPY_TOOL) && (!((Boolean)NTConfig.CONFIG.COPY_CREATIVE_ONLY.get()).booleanValue() || player.m_7500_())) {
            ItemEntity item = player.m_19983_(this.getTent().asItem());
            if (item != null) {
                item.m_32061_();
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() instanceof MalletItem) {
            TentDoorResult tentDoorResult = this.canRemove((LivingEntity)player);
            if (tentDoorResult.isAllow()) {
                TentPlacer.getInstance().removeTent(level, pos, this.getTent().getType(), TentPlacer.getOverworldSize(this.getTent().getSize()), this.getDirection());
                ItemEntity item = player.m_19983_(this.getTent().asItem());
                if (item != null) {
                    item.m_32061_();
                }
            } else if (tentDoorResult.hasMessage()) {
                player.m_5661_((Component)Component.m_237115_((String)tentDoorResult.getRemoveTranslationKey()), true);
            }
            return InteractionResult.SUCCESS;
        }
        TentDoorResult tentDoorResult = this.canEnter((Entity)player);
        if (tentDoorResult.isAllow()) {
            this.onEnter((Entity)player);
        } else if (tentDoorResult.hasMessage()) {
            player.m_5661_((Component)Component.m_237115_((String)tentDoorResult.getEnterTranslationKey()), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Player && !((Boolean)NTConfig.CONFIG.PLAYERS_ENTER_ON_COLLIDE.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)NTConfig.CONFIG.NONPLAYERS_ENTER_ON_COLLIDE.get()).booleanValue()) {
            return;
        }
        TentDoorResult tentDoorResult = this.canEnter(entity);
        if (tentDoorResult.isAllow()) {
            BlockPos respawn = pos.m_5484_(this.getDirection().m_122424_(), 1);
            entity.m_20219_(Vec3.m_82539_((Vec3i)respawn));
            this.onEnter(entity);
        } else if (entity instanceof Player && tentDoorResult.hasMessage()) {
            ((Player)entity).m_5661_((Component)Component.m_237115_((String)tentDoorResult.getEnterTranslationKey()), true);
        }
    }

    public void playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        ItemEntity item;
        if (player.m_7500_() && (item = player.m_19983_(this.getTent().asItem())) != null) {
            item.m_32061_();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag tentTag = this.tent.serializeNBT();
        tag.m_128365_(TENT, (Tag)tentTag);
        tag.m_128359_(DIRECTION, this.direction.m_7912_());
        tag.m_128359_(SPAWN_DIMENSION, this.spawnDimension.toString());
        if (this.spawnpoint != Vec3.f_82478_) {
            CompoundTag spawnpointTag = new CompoundTag();
            spawnpointTag.m_128347_("X", this.spawnpoint.m_7096_());
            spawnpointTag.m_128347_("Y", this.spawnpoint.m_7098_());
            spawnpointTag.m_128347_("Z", this.spawnpoint.m_7094_());
            tag.m_128365_(SPAWNPOINT, (Tag)spawnpointTag);
            tag.m_128350_(SPAWN_ROTATION, this.spawnRot);
        }
        if (this.owner != null) {
            tag.m_128362_(OWNER, this.owner);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag tentTag = tag.m_128469_(TENT);
        this.tent = new Tent(tentTag);
        this.direction = Direction.m_122402_((String)tag.m_128461_(DIRECTION));
        this.spawnDimension = ResourceLocation.m_135820_((String)tag.m_128461_(SPAWN_DIMENSION));
        if (tag.m_128441_(SPAWNPOINT)) {
            CompoundTag spawnpointTag = tag.m_128469_(SPAWNPOINT);
            this.spawnpoint = new Vec3(spawnpointTag.m_128459_("X"), spawnpointTag.m_128459_("Y"), spawnpointTag.m_128459_("Z"));
            this.spawnRot = tag.m_128457_(SPAWN_ROTATION);
        }
        if (tag.m_128441_(OWNER)) {
            this.owner = tag.m_128342_(OWNER);
        }
    }

    public TentDoorResult canEnter(Entity entity) {
        if (null == entity || entity.m_9236_().m_5776_()) {
            return TentDoorResult.DENY_OTHER;
        }
        boolean insideTent = DynamicDimensionHelper.isInsideTent(entity.m_9236_());
        if (insideTent) {
            return TentDoorResult.ALLOW;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)NTConfig.CONFIG.OWNER_ONLY_ENTER.get()).booleanValue() && !player.m_7500_() && !this.isOwner(player)) {
                return TentDoorResult.DENY_NOT_OWNER;
            }
            if (((Boolean)NTConfig.CONFIG.ENTER_WHEN_SAFE.get()).booleanValue() && !entity.m_5833_() && !player.m_7500_() && this.monstersNearby((Player)entity)) {
                return TentDoorResult.DENY_MONSTERS;
            }
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return TentDoorResult.DENY_OTHER;
        }
        if (entity.m_6095_() == EntityType.f_20566_ || entity.m_6095_() == EntityType.f_20521_) {
            return TentDoorResult.DENY_OTHER;
        }
        TentPlacer tentPlacer = TentPlacer.getInstance();
        if (!tentPlacer.isTent(entity.m_9236_(), this.f_58858_, this.tent.getType(), TentPlacer.getOverworldSize(this.tent.getSize()), this.direction)) {
            return TentDoorResult.DENY_INCOMPLETE;
        }
        return TentDoorResult.ALLOW;
    }

    public TentDoorResult canRemove(LivingEntity entity) {
        TentPlacer tentPlacer;
        if (null == entity || entity.m_9236_().m_5776_()) {
            return TentDoorResult.DENY_OTHER;
        }
        boolean insideTent = DynamicDimensionHelper.isInsideTent(entity.m_9236_());
        if (insideTent) {
            return TentDoorResult.DENY_OTHER;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)NTConfig.CONFIG.OWNER_ONLY_PICKUP.get()).booleanValue() && !player.m_7500_() && !this.isOwner(player)) {
                return TentDoorResult.DENY_NOT_OWNER;
            }
            if (((Boolean)NTConfig.CONFIG.PICKUP_WHEN_SAFE.get()).booleanValue() && !entity.m_5833_() && !player.m_7500_() && this.monstersNearby((Player)entity)) {
                return TentDoorResult.DENY_MONSTERS;
            }
        }
        if (!(tentPlacer = TentPlacer.getInstance()).isTent(entity.m_9236_(), this.f_58858_, this.tent.getType(), TentPlacer.getOverworldSize(this.tent.getSize()), this.direction)) {
            return TentDoorResult.DENY_INCOMPLETE;
        }
        return TentDoorResult.ALLOW;
    }

    public void onEnter(Entity entity) {
        if (entity.m_9236_().f_46443_ || null == entity.m_20194_()) {
            return;
        }
        if (entity.m_20092_()) {
            return;
        }
        MinecraftServer server = entity.m_20194_();
        boolean insideTent = DynamicDimensionHelper.isInsideTent(entity.m_9236_());
        if (insideTent) {
            ServerLevel targetLevel = this.getSpawnDimension();
            if (targetLevel != null) {
                DynamicDimensionHelper.exitTent(entity, targetLevel, this.spawnpoint, this.spawnRot);
            }
        } else {
            NTSavedData ntSavedData = NTSavedData.get(server);
            ResourceKey<Level> world = ntSavedData.getOrCreateKey(server, this.tent.getId());
            ServerLevel targetLevel = DynamicDimensionHelper.getOrCreateWorld(server, world, DimensionFactory::createDimension);
            if (targetLevel != null) {
                DynamicDimensionHelper.enterTent(entity, targetLevel, this.tent);
            }
        }
    }

    private boolean monstersNearby(Player player) {
        AABB box = new AABB(this.f_58858_).m_82377_(8.0, 5.0, 8.0);
        List list = player.m_9236_().m_6443_(Monster.class, box, e -> e.m_6935_(player));
        return !list.isEmpty();
    }

    public Tent getTent() {
        return this.tent;
    }

    public void setTent(Tent tent) {
        this.tent = tent;
        this.m_6596_();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        this.m_6596_();
    }

    public Vec3 getSpawnpoint() {
        return this.spawnpoint;
    }

    public ResourceLocation getSpawnDimensionKey() {
        return this.spawnDimension;
    }

    @Nullable
    public ServerLevel getSpawnDimension() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return this.f_58857_.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.spawnDimension));
        }
        return null;
    }

    public void setSpawnpoint(Level world, Vec3 spawnpoint) {
        this.spawnDimension = world.m_46472_().m_135782_();
        this.spawnpoint = spawnpoint;
        this.m_6596_();
    }

    public float getSpawnRot() {
        return this.spawnRot;
    }

    public void setSpawnRot(float spawnRot) {
        this.spawnRot = spawnRot;
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public boolean isOwner(Player player) {
        if (null == this.owner) {
            return true;
        }
        return this.owner.equals(player.m_20148_());
    }

    public static enum TentDoorResult {
        ALLOW(""),
        DENY_INCOMPLETE("incomplete"),
        DENY_NOT_OWNER("not_owner"),
        DENY_MONSTERS("monsters"),
        DENY_OTHER("");

        private final String translationKey;
        private final String enterTranslationKey;
        private final String removeTranslationKey;

        private TentDoorResult(String translationKey) {
            this.translationKey = translationKey;
            this.enterTranslationKey = "tent.enter.deny." + translationKey;
            this.removeTranslationKey = "tent.remove.deny." + translationKey;
        }

        public boolean isAllow() {
            return this == ALLOW;
        }

        public String getEnterTranslationKey() {
            return this.enterTranslationKey;
        }

        public String getRemoveTranslationKey() {
            return this.removeTranslationKey;
        }

        public boolean hasMessage() {
            return !this.translationKey.isEmpty();
        }
    }
}

