/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import nomadictents.NTStructureProcessorsRegistry;
import nomadictents.block.ShamiyanaWallBlock;
import nomadictents.registries.NTBlockRegistry;
import nomadictents.structure.TentPlacer;
import org.jetbrains.annotations.NotNull;

public class ShamiyanaStructureProcessor
extends StructureProcessor {
    public static final Codec<DyeColor> COLOR_CODEC = Codec.STRING.xmap(name -> DyeColor.m_41057_((String)name, (DyeColor)DyeColor.WHITE), DyeColor::m_7912_).stable();
    public static final Codec<ShamiyanaStructureProcessor> CODEC = COLOR_CODEC.xmap(ShamiyanaStructureProcessor::new, ShamiyanaStructureProcessor::getColor).stable();
    private final DyeColor color;

    public ShamiyanaStructureProcessor(DyeColor color) {
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(@NotNull LevelReader level, @NotNull BlockPos rawPos, @NotNull BlockPos pos, @NotNull StructureTemplate.StructureBlockInfo rawBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, @NotNull StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        BlockPos p = blockInfo.f_74675_();
        if (blockInfo.f_74676_().m_60734_() == NTBlockRegistry.WHITE_SHAMIYANA_WALL.get()) {
            boolean pattern = (Boolean)blockInfo.f_74676_().m_61143_((Property)ShamiyanaWallBlock.PATTERN);
            BlockState state = (BlockState)TentPlacer.SHAMIYANA_WALLS.get(this.color).get().m_49966_().m_61124_((Property)ShamiyanaWallBlock.PATTERN, (Comparable)Boolean.valueOf(pattern));
            return new StructureTemplate.StructureBlockInfo(p, state, null);
        }
        return blockInfo;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return NTStructureProcessorsRegistry.TEPEE_PROCESSOR;
    }
}

