/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.registries;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nomadictents.block.FrameBlock;
import nomadictents.block.ShamiyanaWallBlock;
import nomadictents.block.TentDoorBlock;
import nomadictents.block.TepeeBlock;
import nomadictents.item.TentItem;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public class RegUtils {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nomadictents");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nomadictents");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"nomadictents");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"nomadictents");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"nomadictents");

    public static RegistryObject<Block> registerFrameBlock(String name) {
        return BLOCKS.register(name, () -> new FrameBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278166_(PushReaction.BLOCK).m_60913_(-1.0f, 3600000.8f).m_60910_().m_222994_().m_60918_(SoundType.f_56736_)));
    }

    public static RegistryObject<Block> registerTepeeWallBlock(TepeeBlock.Type tepeeType) {
        return BLOCKS.register(tepeeType.m_7912_() + "_tepee_wall", () -> new TepeeBlock(tepeeType, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_278166_(PushReaction.BLOCK).m_60918_(SoundType.f_56745_)));
    }

    public static RegistryObject<Block> registerShamiyanaBlock(DyeColor color) {
        return BLOCKS.register(color.m_7912_() + "_shamiyana_wall", () -> new ShamiyanaWallBlock(color, BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_278166_(PushReaction.BLOCK).m_60918_(SoundType.f_56745_)));
    }

    public static RegistryObject<Block> registerTentDoorBlock(TentSize tentSize, TentType type) {
        return BLOCKS.register(tentSize.m_7912_() + "_" + type.m_7912_() + "_door", () -> new TentDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_278166_(PushReaction.BLOCK).m_60918_(SoundType.f_56745_)));
    }

    public static RegistryObject<TentItem> registerTentItem(TentSize width, TentType type) {
        return ITEMS.register(width.m_7912_() + "_" + type.m_7912_(), () -> new TentItem(type, width, new Item.Properties().m_41487_(1)));
    }

    public static RegistryObject<BlockItem> registerTepeeWallItem(TepeeBlock.Type type) {
        return ITEMS.register(type.m_7912_() + "_tepee_wall", () -> new BlockItem(type.getBlockSupplier().get(), new Item.Properties().m_41487_(1)));
    }

    public static RegistryObject<BlockItem> registerShamiyanaWallItem(DyeColor color, Supplier<? extends Block> blockSupplier) {
        return RegUtils.registerItemBlock(color.m_7912_() + "_shamiyana_wall", blockSupplier);
    }

    public static RegistryObject<BlockItem> registerItemBlock(String name, Supplier<? extends Block> blockSupplier) {
        return ITEMS.register(name, () -> new BlockItem((Block)blockSupplier.get(), new Item.Properties()));
    }
}

