/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.registries;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nomadictents.block.TepeeBlock;
import nomadictents.item.MalletItem;
import nomadictents.item.TentItem;
import nomadictents.item.TentShovelItem;
import nomadictents.registries.NTBlockRegistry;
import nomadictents.registries.RegUtils;
import nomadictents.structure.TentPlacer;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public class NTItemRegistry {
    public static final RegistryObject<Item> TINY_YURT = RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "tiny_yurt"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> MALLET = RegUtils.ITEMS.register("mallet", () -> new MalletItem((Tier)Tiers.IRON, false, new Item.Properties()));
    public static final RegistryObject<Item> GOLDEN_MALLET = RegUtils.ITEMS.register("golden_mallet", () -> new MalletItem((Tier)Tiers.DIAMOND, true, new Item.Properties()));

    public static void init(IEventBus bus) {
        for (TentType tentType : TentType.values()) {
            for (TentSize width : TentSize.values()) {
                RegUtils.ITEMS.register(width.m_7912_() + "_" + tentType.m_7912_(), () -> new TentItem(tentType, width, new Item.Properties().m_41487_(1)));
            }
        }
        RegUtils.ITEMS.register("tent_canvas", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("yurt_section", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("tepee_section", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("indlu_section", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("bedouin_section", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("shamiyana_section", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("golden_crossbeams", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("obsidian_crossbeams", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("diamond_crossbeams", () -> new Item(new Item.Properties()));
        RegUtils.ITEMS.register("stone_tent_shovel", () -> new TentShovelItem(new Item.Properties()));
        RegUtils.ITEMS.register("iron_tent_shovel", () -> new TentShovelItem(new Item.Properties()));
        RegUtils.ITEMS.register("golden_tent_shovel", () -> new TentShovelItem(new Item.Properties()));
        RegUtils.ITEMS.register("obsidian_tent_shovel", () -> new TentShovelItem(new Item.Properties()));
        RegUtils.ITEMS.register("diamond_tent_shovel", () -> new TentShovelItem(new Item.Properties()));
        RegUtils.registerItemBlock("rigid_dirt", NTBlockRegistry.RIGID_DIRT);
        RegUtils.registerItemBlock("yurt_wall", NTBlockRegistry.YURT_WALL);
        RegUtils.registerItemBlock("yurt_roof", NTBlockRegistry.YURT_ROOF);
        RegUtils.registerItemBlock("bedouin_wall", NTBlockRegistry.BEDOUIN_WALL);
        RegUtils.registerItemBlock("bedouin_roof", NTBlockRegistry.BEDOUIN_ROOF);
        RegUtils.registerItemBlock("indlu_wall", NTBlockRegistry.INDLU_WALL);
        for (Enum enum_ : TepeeBlock.Type.values()) {
            RegUtils.registerItemBlock(((TepeeBlock.Type)enum_).m_7912_() + "_tepee_wall", ((TepeeBlock.Type)enum_).getBlockSupplier());
        }
        for (Map.Entry entry : TentPlacer.SHAMIYANA_WALLS.entrySet()) {
            RegUtils.registerItemBlock(((DyeColor)entry.getKey()).m_7912_() + "_shamiyana_wall", (Supplier)entry.getValue());
        }
        RegUtils.registerItemBlock("door_frame", NTBlockRegistry.DOOR_FRAME);
        for (RegistryObject registryObject : TentPlacer.BLOCK_TO_FRAME.values()) {
            RegUtils.registerItemBlock(registryObject.getId().m_135815_(), (Supplier<? extends Block>)registryObject);
        }
        RegUtils.ITEMS.register(bus);
    }
}

