/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.registries;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nomadictents.block.IndluWallBlock;
import nomadictents.block.QuarterTentBlock;
import nomadictents.block.ShamiyanaWallBlock;
import nomadictents.block.TentBlock;
import nomadictents.block.TentDoorBlock;
import nomadictents.block.TepeeBlock;
import nomadictents.block.YurtRoofBlock;
import nomadictents.block.YurtWallBlock;
import nomadictents.registries.RegUtils;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public class NTBlockRegistry {
    public static final RegistryObject<Block> YURT_WALL = RegUtils.BLOCKS.register("yurt_wall", () -> new YurtWallBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283930_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> YURT_ROOF = RegUtils.BLOCKS.register("yurt_roof", () -> new YurtRoofBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283869_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> BEDOUIN_WALL = RegUtils.BLOCKS.register("bedouin_wall", () -> new QuarterTentBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> BEDOUIN_ROOF = RegUtils.BLOCKS.register("bedouin_roof", () -> new TentBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> INDLU_WALL = RegUtils.BLOCKS.register("indlu_wall", () -> new IndluWallBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283824_).m_60955_().m_60971_((b, r, p) -> false).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> RIGID_DIRT = RegUtils.BLOCKS.register("rigid_dirt", () -> new TentBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283762_).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<Block> DOOR_FRAME = RegUtils.registerFrameBlock("door_frame");
    public static final RegistryObject<Block> YURT_WALL_FRAME = RegUtils.registerFrameBlock("yurt_wall_frame");
    public static final RegistryObject<Block> YURT_ROOF_FRAME = RegUtils.registerFrameBlock("yurt_roof_frame");
    public static final RegistryObject<Block> TEPEE_WALL_FRAME = RegUtils.registerFrameBlock("tepee_wall_frame");
    public static final RegistryObject<Block> BEDOUIN_WALL_FRAME = RegUtils.registerFrameBlock("bedouin_wall_frame");
    public static final RegistryObject<Block> BEDOUIN_ROOF_FRAME = RegUtils.registerFrameBlock("bedouin_roof_frame");
    public static final RegistryObject<Block> INDLU_WALL_FRAME = RegUtils.registerFrameBlock("indlu_wall_frame");
    public static final RegistryObject<Block> SHAMIYANA_WALL_FRAME = RegUtils.registerFrameBlock("shamiyana_wall_frame");
    public static final RegistryObject<Block> BLANK_TEPEE_WALL = RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "blank_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS);
    public static final RegistryObject<Block> WHITE_SHAMIYANA_WALL = RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "white_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS);

    public static void init(IEventBus bus) {
        for (TepeeBlock.Type type : TepeeBlock.Type.values()) {
            RegUtils.BLOCKS.register(type.m_7912_() + "_tepee_wall", () -> new TepeeBlock(type, BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283919_).m_60918_(SoundType.f_56745_)));
        }
        for (TepeeBlock.Type type : DyeColor.values()) {
            RegUtils.BLOCKS.register(type.m_7912_() + "_shamiyana_wall", () -> NTBlockRegistry.lambda$init$1((DyeColor)type));
        }
        for (Enum enum_ : TentType.values()) {
            for (TentSize width : TentSize.values()) {
                RegUtils.BLOCKS.register(width.m_7912_() + "_" + ((TentType)enum_).m_7912_() + "_door", () -> new TentDoorBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56745_)));
            }
        }
        RegUtils.BLOCKS.register(bus);
    }

    private static /* synthetic */ ShamiyanaWallBlock lambda$init$1(DyeColor color) {
        return new ShamiyanaWallBlock(color, BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(color.m_284406_()).m_60918_(SoundType.f_56745_));
    }
}

