/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.recipe;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import nomadictents.item.TentItem;
import nomadictents.registries.NTRecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class TentSizeRecipe
extends ShapedRecipe {
    public TentSizeRecipe(ResourceLocation recipeId, ItemStack outputItem, int width, int height, NonNullList<Ingredient> recipeItemsIn) {
        super(recipeId, "tent_size", CraftingBookCategory.BUILDING, width, height, recipeItemsIn, outputItem);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer craftingInventory, @NotNull RegistryAccess access) {
        ItemStack result = super.m_5874_(craftingInventory, access);
        ItemStack tent = TentSizeRecipe.getStackMatching(craftingInventory, i -> i.m_41720_() instanceof TentItem);
        if (!tent.m_41619_()) {
            CompoundTag tag = tent.m_41784_().m_6426_();
            result.m_41751_(tag);
        }
        return result;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)NTRecipeRegistry.TENT_SIZE_RECIPE_SERIALIZER.get();
    }

    public static ItemStack getStackMatching(CraftingContainer inv, Predicate<ItemStack> pred) {
        int l = inv.m_6643_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !pred.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public static final String CATEGORY = "tent_size";

        @NotNull
        public ShapedRecipe m_6729_(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ShapedRecipe recipe = super.m_6729_(recipeId, json);
            return new TentSizeRecipe(recipeId, recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        @NotNull
        public ShapedRecipe m_8005_(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return super.m_8005_(recipeId, buffer);
        }

        public void m_6178_(@NotNull FriendlyByteBuf buffer, @NotNull ShapedRecipe recipeIn) {
            super.m_6178_(buffer, recipeIn);
        }
    }
}

