/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import nomadictents.item.TentItem;
import nomadictents.recipe.TentSizeRecipe;
import nomadictents.registries.NTRecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class TentColorRecipe
extends ShapedRecipe {
    private final DyeColor color;

    public TentColorRecipe(ResourceLocation recipeId, ItemStack outputItem, DyeColor color, int width, int height, NonNullList<Ingredient> recipeItemsIn) {
        super(recipeId, "tent_color", CraftingBookCategory.BUILDING, width, height, recipeItemsIn, TentColorRecipe.outputItemWithColor(outputItem, color));
        this.color = color;
    }

    private static ItemStack outputItemWithColor(ItemStack itemStack, DyeColor color) {
        itemStack.m_41784_().m_128359_("color", color.m_7912_());
        return itemStack;
    }

    public boolean m_5818_(@NotNull CraftingContainer craftingInventory, @NotNull Level level) {
        if (super.m_5818_(craftingInventory, level)) {
            if (this.color == DyeColor.WHITE) {
                return true;
            }
            ItemStack tent = TentSizeRecipe.getStackMatching(craftingInventory, i -> i.m_41720_() instanceof TentItem);
            if (!tent.m_41619_()) {
                String sTentColor = tent.m_41784_().m_128461_("color");
                DyeColor tentColor = DyeColor.m_41057_((String)sTentColor, (DyeColor)DyeColor.WHITE);
                return tentColor == DyeColor.WHITE;
            }
        }
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer craftingInventory, @NotNull RegistryAccess registryAccess) {
        ItemStack result = super.m_5874_(craftingInventory, registryAccess);
        ItemStack tent = TentSizeRecipe.getStackMatching(craftingInventory, i -> i.m_41720_() instanceof TentItem);
        if (!tent.m_41619_()) {
            result = tent.m_41777_();
            CompoundTag tag = result.m_41784_();
            tag.m_128359_("color", this.color.m_7912_());
            result.m_41751_(tag);
        }
        return result;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)NTRecipeRegistry.TENT_COLOR_RECIPE_SERIALIZER.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public static final String CATEGORY = "tent_color";

        @NotNull
        public ShapedRecipe m_6729_(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ShapedRecipe recipe = super.m_6729_(recipeId, json);
            String sColor = "";
            if (json.has("color")) {
                sColor = json.get("color").getAsString();
            }
            DyeColor color = DyeColor.m_41057_((String)sColor, (DyeColor)DyeColor.WHITE);
            return new TentColorRecipe(recipeId, recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), color, recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        @NotNull
        public ShapedRecipe m_8005_(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            ShapedRecipe recipe = super.m_8005_(recipeId, buffer);
            int iColor = buffer.readInt();
            DyeColor color = DyeColor.m_41053_((int)iColor);
            return new TentColorRecipe(recipeId, recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), color, recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        public void m_6178_(@NotNull FriendlyByteBuf buffer, @NotNull ShapedRecipe recipeIn) {
            super.m_6178_(buffer, recipeIn);
            TentColorRecipe recipe = (TentColorRecipe)recipeIn;
            buffer.writeInt(recipe.color.m_41060_());
        }
    }
}

