/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import nomadictents.NTConfig;
import nomadictents.NTSavedData;
import nomadictents.block.FrameBlock;
import nomadictents.dimension.DynamicDimensionHelper;
import nomadictents.registries.NTBlockRegistry;
import nomadictents.structure.TentPlacer;
import nomadictents.util.Tent;
import nomadictents.util.TentLayers;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;
import org.jetbrains.annotations.NotNull;

public class TentItem
extends Item {
    private static final String DOOR = "door";
    private static final String DIRECTION = "direction";
    private final TentType type;
    private final TentSize size;
    private static final CauldronInteraction WASH_TENT = (state, level, pos, player, hand, itemStack) -> {
        if (!itemStack.m_41782_() || !itemStack.m_41784_().m_128441_("color") || DyeColor.m_41057_((String)itemStack.m_41784_().m_128461_("color"), (DyeColor)DyeColor.WHITE) == DyeColor.WHITE) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            ItemStack replace = itemStack.m_41777_();
            replace.m_41784_().m_128359_("color", DyeColor.WHITE.m_7912_());
            player.m_21008_(hand, replace);
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public TentItem(TentType type, TentSize width, Item.Properties properties) {
        super(properties);
        this.type = type;
        this.size = width;
        CauldronInteraction.f_175607_.put(this, WASH_TENT);
    }

    public boolean m_41475_() {
        return super.m_41475_() || (Boolean)NTConfig.CONFIG.TENT_FIREPROOF.get() != false;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag flag) {
        list.add((Component)Component.m_237115_((String)"item.nomadictents.tent.tooltip").m_130940_(this.size.getColor()));
        if (this.type == TentType.SHAMIYANA || stack.m_41782_() && stack.m_41784_().m_128441_("color")) {
            DyeColor color = DyeColor.m_41057_((String)stack.m_41784_().m_128461_("color"), (DyeColor)DyeColor.WHITE);
            String translationKey = "item.minecraft.firework_star." + color.m_7912_();
            list.add((Component)Component.m_237115_((String)translationKey));
        }
        if (flag.m_7050_() || Screen.m_96638_()) {
            byte layers = stack.m_41784_().m_128445_("layers");
            byte maxLayers = TentLayers.getMaxLayers(this.size);
            list.add((Component)Component.m_237110_((String)"item.nomadictents.tent.tooltip.layer", (Object[])new Object[]{layers, maxLayers}).m_130940_(ChatFormatting.GRAY));
            int id = stack.m_41784_().m_128451_("id");
            list.add((Component)Component.m_237110_((String)"item.nomadictents.tent.tooltip.id", (Object[])new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 7200;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        ItemStack itemStack = context.m_43722_();
        if (context.m_43723_() != null) {
            context.m_43723_().m_6672_(context.m_43724_());
        }
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (DynamicDimensionHelper.isInsideTent(context.m_43725_())) {
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"tent.build.deny.inside_tent"), true);
            }
            return InteractionResult.PASS;
        }
        if (NTConfig.CONFIG.isDimensionBlacklist(context.m_43725_())) {
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"tent.build.deny.dimension"), true);
            }
            return InteractionResult.PASS;
        }
        if (NTBlockRegistry.DOOR_FRAME.get() != state.m_60734_()) {
            BlockState replace;
            BlockPos placePos = context.m_8083_();
            if (!context.m_43725_().m_8055_(placePos).m_60629_(new BlockPlaceContext(context))) {
                placePos = placePos.m_121945_(context.m_43719_());
            }
            if (!(replace = context.m_43725_().m_8055_(placePos)).m_247087_()) {
                return InteractionResult.FAIL;
            }
            if (this.canPlaceTent(context.m_43725_(), placePos, context.m_8125_())) {
                context.m_43725_().m_7731_(placePos, ((Block)NTBlockRegistry.DOOR_FRAME.get()).m_49966_(), 3);
                itemStack.m_41784_().m_128365_(DOOR, (Tag)NbtUtils.m_129224_((BlockPos)placePos));
                itemStack.m_41783_().m_128359_(DIRECTION, context.m_8125_().m_7912_());
                return InteractionResult.SUCCESS;
            }
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"tent.build.deny.space"), true);
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return super.onItemUseFirst(stack, context);
    }

    public void m_5551_(@NotNull ItemStack stack, Level level, @NotNull LivingEntity entity, int duration) {
        if (level.f_46443_) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_(DOOR) && stack.m_41783_().m_128441_(DIRECTION)) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_(DOOR));
            Direction direction = Direction.m_122402_((String)stack.m_41783_().m_128461_(DIRECTION));
            if (level.m_46749_(pos)) {
                BlockState state = level.m_8055_(pos);
                if (NTBlockRegistry.DOOR_FRAME.get() == state.m_60734_()) {
                    int progress = (Integer)state.m_61143_((Property)FrameBlock.PROGRESS);
                    if (entity instanceof Player && progress == 7) {
                        this.placeTent(stack, level, pos, direction, (Player)entity);
                    } else {
                        this.cancelTent(stack, level, pos);
                    }
                }
            }
        }
    }

    public void m_5929_(Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int duration) {
        int progress;
        if (level.f_46443_ || duration % 5 != 1) {
            return;
        }
        BlockHitResult result = TentItem.clipFrom(entity, entity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_());
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            entity.m_21253_();
            return;
        }
        BlockPos pos = result.m_82425_();
        BlockState state = level.m_8055_(pos);
        if (NTBlockRegistry.DOOR_FRAME.get() != state.m_60734_()) {
            entity.m_21253_();
            return;
        }
        Direction direction = entity.m_6350_();
        if (stack.m_41784_().m_128441_(DIRECTION)) {
            direction = Direction.m_122402_((String)stack.m_41783_().m_128461_(DIRECTION));
        }
        if ((progress = ((Integer)state.m_61143_((Property)FrameBlock.PROGRESS)).intValue()) == 7) {
            if (entity instanceof Player && this.canPlaceTent(level, pos, direction)) {
                this.placeTent(stack, level, pos, direction, (Player)entity);
                entity.m_21253_();
                return;
            }
            this.cancelTent(stack, level, pos);
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"tent.build.deny.space"), true);
            }
        }
        int next = progress + 2;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FrameBlock.PROGRESS, (Comparable)Integer.valueOf(Math.min(next, 7))), 3);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        this.m_5551_(stack, level, entity, 0);
        return stack;
    }

    private boolean canPlaceTent(Level level, BlockPos startPos, Direction direction) {
        TentPlacer tentPlacer = TentPlacer.getInstance();
        return tentPlacer.canPlaceTentFrame(level, startPos, this.type, this.size, direction);
    }

    private void placeTent(ItemStack stack, Level level, BlockPos clickedPos, Direction direction, @Nullable Player owner) {
        if (level.m_5776_() || null == level.m_7654_()) {
            return;
        }
        if (!stack.m_41784_().m_128441_("id") || stack.m_41784_().m_128451_("id") == 0) {
            NTSavedData ntSavedData = NTSavedData.get(level.m_7654_());
            int tentId = ntSavedData.getNextTentId();
            stack.m_41784_().m_128405_("id", tentId);
        }
        Tent tent = Tent.from(stack, this.type, this.size);
        level.m_46961_(clickedPos, false);
        TentPlacer tentPlacer = TentPlacer.getInstance();
        if (tentPlacer.placeTentFrameWithDoor(level, clickedPos, tent, direction, owner)) {
            stack.m_41774_(1);
        }
    }

    private void cancelTent(ItemStack stack, Level level, BlockPos clickedPos) {
        BlockState state = level.m_8055_(clickedPos);
        if (state.m_60713_((Block)NTBlockRegistry.DOOR_FRAME.get())) {
            level.m_7731_(clickedPos, state.m_60819_().m_76188_(), 3);
        }
        stack.m_41784_().m_128473_(DOOR);
        stack.m_41784_().m_128473_(DIRECTION);
    }

    public static BlockHitResult clipFrom(LivingEntity player, double range) {
        Vec3 startVec = player.m_20299_(1.0f);
        float pitch = (float)Math.toRadians(-player.m_146909_());
        float yaw = (float)Math.toRadians(-player.m_146908_());
        float cosYaw = Mth.m_14089_((float)(yaw - (float)Math.PI));
        float sinYaw = Mth.m_14031_((float)(yaw - (float)Math.PI));
        float cosPitch = -Mth.m_14089_((float)pitch);
        float sinPitch = Mth.m_14031_((float)pitch);
        Vec3 endVec = startVec.m_82520_((double)(sinYaw * cosPitch) * range, (double)sinPitch * range, (double)(cosYaw * cosPitch) * range);
        return player.m_9236_().m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }
}

