/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.dimension;

import commoble.infiniverse.api.InfiniverseAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import nomadictents.NTConfig;
import nomadictents.dimension.DirectTeleporter;
import nomadictents.structure.TentPlacer;
import nomadictents.util.Tent;

public class DynamicDimensionHelper {
    private static final InfiniverseAPI infiniverse = InfiniverseAPI.get();

    public static void enterTent(Entity entity, ServerLevel targetWorld, Tent tent) {
        BlockPos targetPos = Tent.calculatePos(tent.getId());
        Vec3 targetVec = Vec3.m_82539_((Vec3i)targetPos.m_5484_(TentPlacer.TENT_DIRECTION, 1)).m_82520_(0.0, 0.125, 0.0);
        float targetRot = TentPlacer.TENT_DIRECTION.m_122435_();
        targetWorld.m_46865_(targetPos);
        TentPlacer.getInstance().placeOrUpgradeTent((Level)targetWorld, targetPos, tent, (ServerLevel)entity.m_9236_(), entity.m_20182_(), entity.m_146908_());
        DynamicDimensionHelper.sendToDimension(entity, targetWorld, targetVec, targetRot);
    }

    public static void exitTent(Entity entity, ServerLevel targetWorld, Vec3 targetVec, float targetRot) {
        targetRot = Mth.m_14177_((float)(targetRot + 180.0f));
        targetWorld.m_46865_(new BlockPos((int)targetVec.f_82479_, (int)targetVec.f_82480_, (int)targetVec.f_82481_));
        DynamicDimensionHelper.sendToDimension(entity, targetWorld, targetVec, targetRot);
    }

    private static void sendToDimension(Entity entity, ServerLevel targetWorld, Vec3 targetVec, float targetRot) {
        targetWorld.m_46865_(new BlockPos((int)targetVec.f_82479_, (int)targetVec.f_82480_, (int)targetVec.f_82481_));
        DirectTeleporter teleporter = DirectTeleporter.create(entity, targetVec, targetRot, TentPlacer.TENT_DIRECTION);
        entity.changeDimension(targetWorld, (ITeleporter)teleporter);
        entity.f_19839_ = (Integer)NTConfig.CONFIG.PORTAL_COOLDOWN.get();
    }

    public static boolean isInsideTent(Level level) {
        return DynamicDimensionHelper.isInsideTent(level.m_46472_().m_135782_());
    }

    public static boolean isInsideTent(ResourceLocation dimensionId) {
        return "nomadictents".equals(dimensionId.m_135827_());
    }

    public static List<ResourceKey<Level>> getTents(MinecraftServer server) {
        ArrayList<ResourceKey<Level>> list = new ArrayList<ResourceKey<Level>>();
        for (ResourceKey world : server.m_129784_()) {
            if (!DynamicDimensionHelper.isInsideTent(world.m_135782_())) continue;
            list.add((ResourceKey<Level>)world);
        }
        return list;
    }

    public static ServerLevel getOrCreateWorld(MinecraftServer server, ResourceKey<Level> levelKey, Function<MinecraftServer, LevelStem> dimensionFactory) {
        return infiniverse.getOrCreateLevel(server, levelKey, () -> (LevelStem)dimensionFactory.apply(server));
    }
}

