/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nomadictents.NTConfig;
import nomadictents.block.TentBlock;
import org.jetbrains.annotations.NotNull;

public class TepeeBlock
extends TentBlock {
    private final Type type;

    public TepeeBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Override
    public BlockState getDoorAwareState(Level level, BlockState state, BlockPos pos, @Nullable BlockPos doorPos) {
        if (this.type == Type.BLANK) {
            int dy;
            RandomSource rand = level.m_213780_();
            if (doorPos != null && (dy = pos.m_123342_() - doorPos.m_123342_()) % 2 == 0) {
                rand = RandomSource.m_216335_((long)doorPos.m_6630_(dy).hashCode());
                return TepeeBlock.getRandomPattern(rand);
            }
            if (rand.m_188503_(100) < (Integer)NTConfig.CONFIG.TEPEE_DECORATED_CHANCE.get()) {
                return TepeeBlock.getRandomSymbol(rand);
            }
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return super.m_5573_(context);
    }

    public static BlockState getRandomPattern(RandomSource rand) {
        int index = rand.m_188503_(Type.PATTERNS.size());
        return Type.PATTERNS.get(index).getBlockState();
    }

    public static BlockState getRandomSymbol(RandomSource rand) {
        int index = rand.m_188503_(Type.SYMBOLS.size());
        return Type.SYMBOLS.get(index).getBlockState();
    }

    public static enum Type implements StringRepresentable
    {
        BLANK("blank", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "blank_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        CHANNEL("channel", true, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "channel_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        CREEPER("creeper", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "creeper_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        DREAMCATCHER("dreamcatcher", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "dreamcatcher_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        EAGLE("eagle", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "eagle_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        GOLEM("golem", true, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "golem_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        HOPE("hope", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "hope_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        MAGIC("magic", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "magic_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        RADIAL("radial", true, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "radial_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        RAIN("rain", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "rain_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        SPACE("space", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "space_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        SUN("sun", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "sun_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        TRIFORCE("triforce", false, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "triforce_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        WEDGE("wedge", true, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "wedge_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)),
        ZIGZAG("zigzag", true, (Supplier<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "zigzag_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS));

        private final String name;
        private final boolean isPattern;
        private final Supplier<Block> block;
        private static final List<Type> PATTERNS;
        private static final List<Type> SYMBOLS;

        private Type(String name, boolean isPattern, Supplier<Block> block) {
            this.name = name;
            this.isPattern = isPattern;
            this.block = block;
        }

        public Supplier<Block> getBlockSupplier() {
            return this.block;
        }

        public BlockState getBlockState() {
            return this.block.get().m_49966_();
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        static {
            PATTERNS = (List)Arrays.stream(Type.values()).filter(Type::isPattern).collect(ImmutableList.toImmutableList());
            SYMBOLS = (List)Arrays.stream(Type.values()).filter(t -> !t.isPattern()).collect(ImmutableList.toImmutableList());
        }
    }
}

